/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SuggestRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SuggestRequest> {
    private final String query;
    private final String suggester;
    private final Long size;

    private SuggestRequest(BuilderImpl builder) {
        this.query = builder.query;
        this.suggester = builder.suggester;
        this.size = builder.size;
    }

    public String query() {
        return this.query;
    }

    public String suggester() {
        return this.suggester;
    }

    public Long size() {
        return this.size;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.query() == null ? 0 : this.query().hashCode());
        hashCode = 31 * hashCode + (this.suggester() == null ? 0 : this.suggester().hashCode());
        hashCode = 31 * hashCode + (this.size() == null ? 0 : this.size().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestRequest)) {
            return false;
        }
        SuggestRequest other = (SuggestRequest)((Object)obj);
        if (other.query() == null ^ this.query() == null) {
            return false;
        }
        if (other.query() != null && !other.query().equals(this.query())) {
            return false;
        }
        if (other.suggester() == null ^ this.suggester() == null) {
            return false;
        }
        if (other.suggester() != null && !other.suggester().equals(this.suggester())) {
            return false;
        }
        if (other.size() == null ^ this.size() == null) {
            return false;
        }
        return other.size() == null || other.size().equals(this.size());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.query() != null) {
            sb.append("Query: ").append(this.query()).append(",");
        }
        if (this.suggester() != null) {
            sb.append("Suggester: ").append(this.suggester()).append(",");
        }
        if (this.size() != null) {
            sb.append("Size: ").append(this.size()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String query;
        private String suggester;
        private Long size;

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestRequest model) {
            this.setQuery(model.query);
            this.setSuggester(model.suggester);
            this.setSize(model.size);
        }

        public final String getQuery() {
            return this.query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        public final String getSuggester() {
            return this.suggester;
        }

        @Override
        public final Builder suggester(String suggester) {
            this.suggester = suggester;
            return this;
        }

        public final void setSuggester(String suggester) {
            this.suggester = suggester;
        }

        public final Long getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        public SuggestRequest build() {
            return new SuggestRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SuggestRequest> {
        public Builder query(String var1);

        public Builder suggester(String var1);

        public Builder size(Long var1);
    }
}

