/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudsearch.model.CreateDomainRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateDomainRequestMarshaller
implements Marshaller<Request<CreateDomainRequest>, CreateDomainRequest> {
    public Request<CreateDomainRequest> marshall(CreateDomainRequest createDomainRequest) {
        if (createDomainRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDomainRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "CreateDomain");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDomainRequest.domainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)createDomainRequest.domainName()));
        }
        return request;
    }
}

