/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cloudsearchdomain.model.DocumentServiceWarning;
import software.amazon.awssdk.services.cloudsearchdomain.model.DocumentServiceWarningsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UploadDocumentsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, UploadDocumentsResponse> {
    private final String status;
    private final Long adds;
    private final Long deletes;
    private final List<DocumentServiceWarning> warnings;

    private UploadDocumentsResponse(BuilderImpl builder) {
        this.status = builder.status;
        this.adds = builder.adds;
        this.deletes = builder.deletes;
        this.warnings = builder.warnings;
    }

    public String status() {
        return this.status;
    }

    public Long adds() {
        return this.adds;
    }

    public Long deletes() {
        return this.deletes;
    }

    public List<DocumentServiceWarning> warnings() {
        return this.warnings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.adds() == null ? 0 : this.adds().hashCode());
        hashCode = 31 * hashCode + (this.deletes() == null ? 0 : this.deletes().hashCode());
        hashCode = 31 * hashCode + (this.warnings() == null ? 0 : this.warnings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadDocumentsResponse)) {
            return false;
        }
        UploadDocumentsResponse other = (UploadDocumentsResponse)((Object)obj);
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.adds() == null ^ this.adds() == null) {
            return false;
        }
        if (other.adds() != null && !other.adds().equals(this.adds())) {
            return false;
        }
        if (other.deletes() == null ^ this.deletes() == null) {
            return false;
        }
        if (other.deletes() != null && !other.deletes().equals(this.deletes())) {
            return false;
        }
        if (other.warnings() == null ^ this.warnings() == null) {
            return false;
        }
        return other.warnings() == null || other.warnings().equals(this.warnings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.adds() != null) {
            sb.append("Adds: ").append(this.adds()).append(",");
        }
        if (this.deletes() != null) {
            sb.append("Deletes: ").append(this.deletes()).append(",");
        }
        if (this.warnings() != null) {
            sb.append("Warnings: ").append(this.warnings()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String status;
        private Long adds;
        private Long deletes;
        private List<DocumentServiceWarning> warnings;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadDocumentsResponse model) {
            this.setStatus(model.status);
            this.setAdds(model.adds);
            this.setDeletes(model.deletes);
            this.setWarnings(model.warnings);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Long getAdds() {
            return this.adds;
        }

        @Override
        public final Builder adds(Long adds) {
            this.adds = adds;
            return this;
        }

        public final void setAdds(Long adds) {
            this.adds = adds;
        }

        public final Long getDeletes() {
            return this.deletes;
        }

        @Override
        public final Builder deletes(Long deletes) {
            this.deletes = deletes;
            return this;
        }

        public final void setDeletes(Long deletes) {
            this.deletes = deletes;
        }

        public final Collection<DocumentServiceWarning> getWarnings() {
            return this.warnings;
        }

        @Override
        public final Builder warnings(Collection<DocumentServiceWarning> warnings) {
            this.warnings = DocumentServiceWarningsCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(DocumentServiceWarning ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        public final void setWarnings(Collection<DocumentServiceWarning> warnings) {
            this.warnings = DocumentServiceWarningsCopier.copy(warnings);
        }

        @SafeVarargs
        public final void setWarnings(DocumentServiceWarning ... warnings) {
            this.warnings(Arrays.asList(warnings));
        }

        public UploadDocumentsResponse build() {
            return new UploadDocumentsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UploadDocumentsResponse> {
        public Builder status(String var1);

        public Builder adds(Long var1);

        public Builder deletes(Long var1);

        public Builder warnings(Collection<DocumentServiceWarning> var1);

        public Builder warnings(DocumentServiceWarning ... var1);
    }
}

