/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.StreamingRequestMarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.CloudSearchDomainClient;
import software.amazon.awssdk.services.cloudsearchdomain.model.CloudSearchDomainException;
import software.amazon.awssdk.services.cloudsearchdomain.model.DocumentServiceException;
import software.amazon.awssdk.services.cloudsearchdomain.model.SearchException;
import software.amazon.awssdk.services.cloudsearchdomain.model.SearchRequest;
import software.amazon.awssdk.services.cloudsearchdomain.model.SearchResponse;
import software.amazon.awssdk.services.cloudsearchdomain.model.SuggestRequest;
import software.amazon.awssdk.services.cloudsearchdomain.model.SuggestResponse;
import software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsRequest;
import software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsResponse;
import software.amazon.awssdk.services.cloudsearchdomain.transform.SearchRequestMarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.transform.SearchResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.transform.SuggestRequestMarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.transform.SuggestResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.transform.UploadDocumentsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.transform.UploadDocumentsResponseUnmarshaller;
import software.amazon.awssdk.sync.RequestBody;

@SdkInternalApi
final class DefaultCloudSearchDomainClient
implements CloudSearchDomainClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final AwsSyncClientParams clientParams;

    protected DefaultCloudSearchDomainClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = this.init();
    }

    @Override
    public SearchResponse search(SearchRequest searchRequest) throws SearchException, SdkBaseException, SdkClientException, CloudSearchDomainException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new SearchResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (SearchResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)searchRequest).withMarshaller((Marshaller)new SearchRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public SuggestResponse suggest(SuggestRequest suggestRequest) throws SearchException, SdkBaseException, SdkClientException, CloudSearchDomainException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new SuggestResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (SuggestResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)suggestRequest).withMarshaller((Marshaller)new SuggestRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UploadDocumentsResponse uploadDocuments(UploadDocumentsRequest uploadDocumentsRequest, RequestBody requestBody) throws DocumentServiceException, SdkBaseException, SdkClientException, CloudSearchDomainException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UploadDocumentsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UploadDocumentsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)uploadDocumentsRequest).withMarshaller((Marshaller)new StreamingRequestMarshaller((Marshaller)new UploadDocumentsRequestMarshaller(this.protocolFactory), requestBody))));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(CloudSearchDomainException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SearchException").withModeledClass(SearchException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DocumentServiceException").withModeledClass(DocumentServiceException.class)));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }
}

