/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.w3c.dom.Node;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AsyncClientHandler;
import software.amazon.awssdk.client.AwsAsyncClientParams;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkAsyncClientHandler;
import software.amazon.awssdk.http.DefaultErrorResponseHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.http.StaxResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.StandardErrorUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudsearch.CloudSearchAsyncClient;
import software.amazon.awssdk.services.cloudsearch.model.BuildSuggestersRequest;
import software.amazon.awssdk.services.cloudsearch.model.BuildSuggestersResponse;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchException;
import software.amazon.awssdk.services.cloudsearch.model.CreateDomainRequest;
import software.amazon.awssdk.services.cloudsearch.model.CreateDomainResponse;
import software.amazon.awssdk.services.cloudsearch.model.DefineAnalysisSchemeRequest;
import software.amazon.awssdk.services.cloudsearch.model.DefineAnalysisSchemeResponse;
import software.amazon.awssdk.services.cloudsearch.model.DefineExpressionRequest;
import software.amazon.awssdk.services.cloudsearch.model.DefineExpressionResponse;
import software.amazon.awssdk.services.cloudsearch.model.DefineIndexFieldRequest;
import software.amazon.awssdk.services.cloudsearch.model.DefineIndexFieldResponse;
import software.amazon.awssdk.services.cloudsearch.model.DefineSuggesterRequest;
import software.amazon.awssdk.services.cloudsearch.model.DefineSuggesterResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteAnalysisSchemeRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteAnalysisSchemeResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteDomainRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteDomainResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteExpressionRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteExpressionResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteIndexFieldRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteIndexFieldResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteSuggesterRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteSuggesterResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAnalysisSchemesRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAnalysisSchemesResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAvailabilityOptionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAvailabilityOptionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeExpressionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeExpressionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeIndexFieldsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeIndexFieldsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeScalingParametersRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeScalingParametersResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeServiceAccessPoliciesResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeSuggestersRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeSuggestersResponse;
import software.amazon.awssdk.services.cloudsearch.model.IndexDocumentsRequest;
import software.amazon.awssdk.services.cloudsearch.model.IndexDocumentsResponse;
import software.amazon.awssdk.services.cloudsearch.model.ListDomainNamesRequest;
import software.amazon.awssdk.services.cloudsearch.model.ListDomainNamesResponse;
import software.amazon.awssdk.services.cloudsearch.model.UpdateAvailabilityOptionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.UpdateAvailabilityOptionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.UpdateScalingParametersRequest;
import software.amazon.awssdk.services.cloudsearch.model.UpdateScalingParametersResponse;
import software.amazon.awssdk.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest;
import software.amazon.awssdk.services.cloudsearch.model.UpdateServiceAccessPoliciesResponse;
import software.amazon.awssdk.services.cloudsearch.transform.BaseExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.BuildSuggestersRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.BuildSuggestersResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.CreateDomainRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.CreateDomainResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DefineAnalysisSchemeRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DefineAnalysisSchemeResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DefineExpressionRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DefineExpressionResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DefineIndexFieldRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DefineIndexFieldResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DefineSuggesterRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DefineSuggesterResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DeleteAnalysisSchemeRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DeleteAnalysisSchemeResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DeleteDomainRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DeleteDomainResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DeleteExpressionRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DeleteExpressionResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DeleteIndexFieldRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DeleteIndexFieldResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DeleteSuggesterRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DeleteSuggesterResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeAnalysisSchemesRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeAnalysisSchemesResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeAvailabilityOptionsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeAvailabilityOptionsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeDomainsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeDomainsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeExpressionsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeExpressionsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeIndexFieldsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeIndexFieldsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeScalingParametersRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeScalingParametersResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeServiceAccessPoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeServiceAccessPoliciesResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeSuggestersRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeSuggestersResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DisabledOperationExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.IndexDocumentsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.IndexDocumentsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.InternalExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.InvalidTypeExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.LimitExceededExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.ListDomainNamesRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.ListDomainNamesResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.ResourceNotFoundExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.UpdateAvailabilityOptionsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.UpdateAvailabilityOptionsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.UpdateScalingParametersRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.UpdateScalingParametersResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.UpdateServiceAccessPoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.UpdateServiceAccessPoliciesResponseUnmarshaller;

@SdkInternalApi
final class DefaultCloudSearchAsyncClient
implements CloudSearchAsyncClient {
    private final AsyncClientHandler clientHandler;
    private final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers;

    protected DefaultCloudSearchAsyncClient(AwsAsyncClientParams clientParams) {
        this.clientHandler = new SdkAsyncClientHandler(new ClientHandlerParams().withAsyncClientParams(clientParams).withClientParams((AwsSyncClientParams)clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.exceptionUnmarshallers = this.init();
    }

    @Override
    public CompletableFuture<BuildSuggestersResponse> buildSuggesters(BuildSuggestersRequest buildSuggestersRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new BuildSuggestersResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new BuildSuggestersRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)buildSuggestersRequest));
    }

    @Override
    public CompletableFuture<CreateDomainResponse> createDomain(CreateDomainRequest createDomainRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateDomainResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateDomainRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)createDomainRequest));
    }

    @Override
    public CompletableFuture<DefineAnalysisSchemeResponse> defineAnalysisScheme(DefineAnalysisSchemeRequest defineAnalysisSchemeRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DefineAnalysisSchemeResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DefineAnalysisSchemeRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)defineAnalysisSchemeRequest));
    }

    @Override
    public CompletableFuture<DefineExpressionResponse> defineExpression(DefineExpressionRequest defineExpressionRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DefineExpressionResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DefineExpressionRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)defineExpressionRequest));
    }

    @Override
    public CompletableFuture<DefineIndexFieldResponse> defineIndexField(DefineIndexFieldRequest defineIndexFieldRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DefineIndexFieldResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DefineIndexFieldRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)defineIndexFieldRequest));
    }

    @Override
    public CompletableFuture<DefineSuggesterResponse> defineSuggester(DefineSuggesterRequest defineSuggesterRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DefineSuggesterResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DefineSuggesterRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)defineSuggesterRequest));
    }

    @Override
    public CompletableFuture<DeleteAnalysisSchemeResponse> deleteAnalysisScheme(DeleteAnalysisSchemeRequest deleteAnalysisSchemeRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteAnalysisSchemeResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteAnalysisSchemeRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)deleteAnalysisSchemeRequest));
    }

    @Override
    public CompletableFuture<DeleteDomainResponse> deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteDomainResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteDomainRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)deleteDomainRequest));
    }

    @Override
    public CompletableFuture<DeleteExpressionResponse> deleteExpression(DeleteExpressionRequest deleteExpressionRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteExpressionResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteExpressionRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)deleteExpressionRequest));
    }

    @Override
    public CompletableFuture<DeleteIndexFieldResponse> deleteIndexField(DeleteIndexFieldRequest deleteIndexFieldRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteIndexFieldResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteIndexFieldRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)deleteIndexFieldRequest));
    }

    @Override
    public CompletableFuture<DeleteSuggesterResponse> deleteSuggester(DeleteSuggesterRequest deleteSuggesterRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteSuggesterResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteSuggesterRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)deleteSuggesterRequest));
    }

    @Override
    public CompletableFuture<DescribeAnalysisSchemesResponse> describeAnalysisSchemes(DescribeAnalysisSchemesRequest describeAnalysisSchemesRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeAnalysisSchemesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeAnalysisSchemesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)describeAnalysisSchemesRequest));
    }

    @Override
    public CompletableFuture<DescribeAvailabilityOptionsResponse> describeAvailabilityOptions(DescribeAvailabilityOptionsRequest describeAvailabilityOptionsRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeAvailabilityOptionsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeAvailabilityOptionsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)describeAvailabilityOptionsRequest));
    }

    @Override
    public CompletableFuture<DescribeDomainsResponse> describeDomains() {
        return this.describeDomains((DescribeDomainsRequest)((Object)DescribeDomainsRequest.builder().build()));
    }

    @Override
    public CompletableFuture<DescribeDomainsResponse> describeDomains(DescribeDomainsRequest describeDomainsRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeDomainsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeDomainsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)describeDomainsRequest));
    }

    @Override
    public CompletableFuture<DescribeExpressionsResponse> describeExpressions(DescribeExpressionsRequest describeExpressionsRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeExpressionsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeExpressionsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)describeExpressionsRequest));
    }

    @Override
    public CompletableFuture<DescribeIndexFieldsResponse> describeIndexFields(DescribeIndexFieldsRequest describeIndexFieldsRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeIndexFieldsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeIndexFieldsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)describeIndexFieldsRequest));
    }

    @Override
    public CompletableFuture<DescribeScalingParametersResponse> describeScalingParameters(DescribeScalingParametersRequest describeScalingParametersRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeScalingParametersResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeScalingParametersRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)describeScalingParametersRequest));
    }

    @Override
    public CompletableFuture<DescribeServiceAccessPoliciesResponse> describeServiceAccessPolicies(DescribeServiceAccessPoliciesRequest describeServiceAccessPoliciesRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeServiceAccessPoliciesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeServiceAccessPoliciesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)describeServiceAccessPoliciesRequest));
    }

    @Override
    public CompletableFuture<DescribeSuggestersResponse> describeSuggesters(DescribeSuggestersRequest describeSuggestersRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeSuggestersResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeSuggestersRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)describeSuggestersRequest));
    }

    @Override
    public CompletableFuture<IndexDocumentsResponse> indexDocuments(IndexDocumentsRequest indexDocumentsRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new IndexDocumentsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new IndexDocumentsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)indexDocumentsRequest));
    }

    @Override
    public CompletableFuture<ListDomainNamesResponse> listDomainNames() {
        return this.listDomainNames((ListDomainNamesRequest)((Object)ListDomainNamesRequest.builder().build()));
    }

    @Override
    public CompletableFuture<ListDomainNamesResponse> listDomainNames(ListDomainNamesRequest listDomainNamesRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListDomainNamesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListDomainNamesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)listDomainNamesRequest));
    }

    @Override
    public CompletableFuture<UpdateAvailabilityOptionsResponse> updateAvailabilityOptions(UpdateAvailabilityOptionsRequest updateAvailabilityOptionsRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new UpdateAvailabilityOptionsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateAvailabilityOptionsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)updateAvailabilityOptionsRequest));
    }

    @Override
    public CompletableFuture<UpdateScalingParametersResponse> updateScalingParameters(UpdateScalingParametersRequest updateScalingParametersRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new UpdateScalingParametersResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateScalingParametersRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)updateScalingParametersRequest));
    }

    @Override
    public CompletableFuture<UpdateServiceAccessPoliciesResponse> updateServiceAccessPolicies(UpdateServiceAccessPoliciesRequest updateServiceAccessPoliciesRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new UpdateServiceAccessPoliciesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateServiceAccessPoliciesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)updateServiceAccessPoliciesRequest));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }

    private List<Unmarshaller<AmazonServiceException, Node>> init() {
        ArrayList<Unmarshaller<AmazonServiceException, Node>> unmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new DisabledOperationExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new ResourceNotFoundExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new BaseExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InternalExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new LimitExceededExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidTypeExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new StandardErrorUnmarshaller(CloudSearchException.class));
        return unmarshallers;
    }
}

