/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainsRequest;

public class DescribeDomainsRequestMarshaller
implements Marshaller<Request<DescribeDomainsRequest>, DescribeDomainsRequest> {
    public Request<DescribeDomainsRequest> marshall(DescribeDomainsRequest describeDomainsRequest) {
        if (describeDomainsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeDomainsRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeDomains");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDomainsRequest.domainNames().isEmpty() && !(describeDomainsRequest.domainNames() instanceof SdkAutoConstructList)) {
            request.addParameter("DomainNames", "");
        } else if (!describeDomainsRequest.domainNames().isEmpty() && !(describeDomainsRequest.domainNames() instanceof SdkAutoConstructList)) {
            List<String> domainNamesList = describeDomainsRequest.domainNames();
            int domainNamesListIndex = 1;
            for (String domainNamesListValue : domainNamesList) {
                if (domainNamesListValue != null) {
                    request.addParameter("DomainNames.member." + domainNamesListIndex, StringConversion.fromString((String)domainNamesListValue));
                }
                ++domainNamesListIndex;
            }
        }
        return request;
    }
}

