/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudsearch.model.DeleteDomainRequest;

public class DeleteDomainRequestMarshaller
implements Marshaller<Request<DeleteDomainRequest>, DeleteDomainRequest> {
    public Request<DeleteDomainRequest> marshall(DeleteDomainRequest deleteDomainRequest) {
        if (deleteDomainRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteDomainRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DeleteDomain");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteDomainRequest.domainName() != null) {
            request.addParameter("DomainName", StringConversion.fromString((String)deleteDomainRequest.domainName()));
        }
        return request;
    }
}

