/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudsearch.model.DefineSuggesterRequest;
import software.amazon.awssdk.services.cloudsearch.model.DocumentSuggesterOptions;
import software.amazon.awssdk.services.cloudsearch.model.Suggester;

public class DefineSuggesterRequestMarshaller
implements Marshaller<Request<DefineSuggesterRequest>, DefineSuggesterRequest> {
    public Request<DefineSuggesterRequest> marshall(DefineSuggesterRequest defineSuggesterRequest) {
        Suggester suggester;
        if (defineSuggesterRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)defineSuggesterRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DefineSuggester");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (defineSuggesterRequest.domainName() != null) {
            request.addParameter("DomainName", StringConversion.fromString((String)defineSuggesterRequest.domainName()));
        }
        if ((suggester = defineSuggesterRequest.suggester()) != null) {
            DocumentSuggesterOptions documentSuggesterOptions;
            if (suggester.suggesterName() != null) {
                request.addParameter("Suggester.SuggesterName", StringConversion.fromString((String)suggester.suggesterName()));
            }
            if ((documentSuggesterOptions = suggester.documentSuggesterOptions()) != null) {
                if (documentSuggesterOptions.sourceField() != null) {
                    request.addParameter("Suggester.DocumentSuggesterOptions.SourceField", StringConversion.fromString((String)documentSuggesterOptions.sourceField()));
                }
                if (documentSuggesterOptions.fuzzyMatchingAsString() != null) {
                    request.addParameter("Suggester.DocumentSuggesterOptions.FuzzyMatching", StringConversion.fromString((String)documentSuggesterOptions.fuzzyMatchingAsString()));
                }
                if (documentSuggesterOptions.sortExpression() != null) {
                    request.addParameter("Suggester.DocumentSuggesterOptions.SortExpression", StringConversion.fromString((String)documentSuggesterOptions.sortExpression()));
                }
            }
        }
        return request;
    }
}

