/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudsearch.model.ScalingParameters;

public class ScalingParametersUnmarshaller
implements Unmarshaller<ScalingParameters, StaxUnmarshallerContext> {
    private static final ScalingParametersUnmarshaller INSTANCE = new ScalingParametersUnmarshaller();

    public ScalingParameters unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ScalingParameters.Builder scalingParameters = ScalingParameters.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DesiredInstanceType", targetDepth)) {
                    scalingParameters.desiredInstanceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DesiredReplicationCount", targetDepth)) {
                    scalingParameters.desiredReplicationCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DesiredPartitionCount", targetDepth)) continue;
                scalingParameters.desiredPartitionCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ScalingParameters)scalingParameters.build();
    }

    public static ScalingParametersUnmarshaller getInstance() {
        return INSTANCE;
    }
}

