/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudsearch.model.Limits;
import software.amazon.awssdk.services.cloudsearch.model.ServiceEndpoint;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainStatus
implements ToCopyableBuilder<Builder, DomainStatus> {
    private final String domainId;
    private final String domainName;
    private final String arn;
    private final Boolean created;
    private final Boolean deleted;
    private final ServiceEndpoint docService;
    private final ServiceEndpoint searchService;
    private final Boolean requiresIndexDocuments;
    private final Boolean processing;
    private final String searchInstanceType;
    private final Integer searchPartitionCount;
    private final Integer searchInstanceCount;
    private final Limits limits;

    private DomainStatus(BuilderImpl builder) {
        this.domainId = builder.domainId;
        this.domainName = builder.domainName;
        this.arn = builder.arn;
        this.created = builder.created;
        this.deleted = builder.deleted;
        this.docService = builder.docService;
        this.searchService = builder.searchService;
        this.requiresIndexDocuments = builder.requiresIndexDocuments;
        this.processing = builder.processing;
        this.searchInstanceType = builder.searchInstanceType;
        this.searchPartitionCount = builder.searchPartitionCount;
        this.searchInstanceCount = builder.searchInstanceCount;
        this.limits = builder.limits;
    }

    public String domainId() {
        return this.domainId;
    }

    public String domainName() {
        return this.domainName;
    }

    public String arn() {
        return this.arn;
    }

    public Boolean created() {
        return this.created;
    }

    public Boolean deleted() {
        return this.deleted;
    }

    public ServiceEndpoint docService() {
        return this.docService;
    }

    public ServiceEndpoint searchService() {
        return this.searchService;
    }

    public Boolean requiresIndexDocuments() {
        return this.requiresIndexDocuments;
    }

    public Boolean processing() {
        return this.processing;
    }

    public String searchInstanceType() {
        return this.searchInstanceType;
    }

    public Integer searchPartitionCount() {
        return this.searchPartitionCount;
    }

    public Integer searchInstanceCount() {
        return this.searchInstanceCount;
    }

    public Limits limits() {
        return this.limits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.docService());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchService());
        hashCode = 31 * hashCode + Objects.hashCode(this.requiresIndexDocuments());
        hashCode = 31 * hashCode + Objects.hashCode(this.processing());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchPartitionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.limits());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainStatus)) {
            return false;
        }
        DomainStatus other = (DomainStatus)obj;
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.deleted(), other.deleted()) && Objects.equals(this.docService(), other.docService()) && Objects.equals(this.searchService(), other.searchService()) && Objects.equals(this.requiresIndexDocuments(), other.requiresIndexDocuments()) && Objects.equals(this.processing(), other.processing()) && Objects.equals(this.searchInstanceType(), other.searchInstanceType()) && Objects.equals(this.searchPartitionCount(), other.searchPartitionCount()) && Objects.equals(this.searchInstanceCount(), other.searchInstanceCount()) && Objects.equals(this.limits(), other.limits());
    }

    public String toString() {
        return ToString.builder((String)"DomainStatus").add("DomainId", (Object)this.domainId()).add("DomainName", (Object)this.domainName()).add("ARN", (Object)this.arn()).add("Created", (Object)this.created()).add("Deleted", (Object)this.deleted()).add("DocService", (Object)this.docService()).add("SearchService", (Object)this.searchService()).add("RequiresIndexDocuments", (Object)this.requiresIndexDocuments()).add("Processing", (Object)this.processing()).add("SearchInstanceType", (Object)this.searchInstanceType()).add("SearchPartitionCount", (Object)this.searchPartitionCount()).add("SearchInstanceCount", (Object)this.searchInstanceCount()).add("Limits", (Object)this.limits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "Deleted": {
                return Optional.ofNullable(clazz.cast(this.deleted()));
            }
            case "DocService": {
                return Optional.ofNullable(clazz.cast(this.docService()));
            }
            case "SearchService": {
                return Optional.ofNullable(clazz.cast(this.searchService()));
            }
            case "RequiresIndexDocuments": {
                return Optional.ofNullable(clazz.cast(this.requiresIndexDocuments()));
            }
            case "Processing": {
                return Optional.ofNullable(clazz.cast(this.processing()));
            }
            case "SearchInstanceType": {
                return Optional.ofNullable(clazz.cast(this.searchInstanceType()));
            }
            case "SearchPartitionCount": {
                return Optional.ofNullable(clazz.cast(this.searchPartitionCount()));
            }
            case "SearchInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.searchInstanceCount()));
            }
            case "Limits": {
                return Optional.ofNullable(clazz.cast(this.limits()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String domainId;
        private String domainName;
        private String arn;
        private Boolean created;
        private Boolean deleted;
        private ServiceEndpoint docService;
        private ServiceEndpoint searchService;
        private Boolean requiresIndexDocuments;
        private Boolean processing;
        private String searchInstanceType;
        private Integer searchPartitionCount;
        private Integer searchInstanceCount;
        private Limits limits;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainStatus model) {
            this.domainId(model.domainId);
            this.domainName(model.domainName);
            this.arn(model.arn);
            this.created(model.created);
            this.deleted(model.deleted);
            this.docService(model.docService);
            this.searchService(model.searchService);
            this.requiresIndexDocuments(model.requiresIndexDocuments);
            this.processing(model.processing);
            this.searchInstanceType(model.searchInstanceType);
            this.searchPartitionCount(model.searchPartitionCount);
            this.searchInstanceCount(model.searchInstanceCount);
            this.limits(model.limits);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getARN() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final Boolean getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Boolean created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Boolean created) {
            this.created = created;
        }

        public final Boolean getDeleted() {
            return this.deleted;
        }

        @Override
        public final Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public final void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public final ServiceEndpoint.Builder getDocService() {
            return this.docService != null ? this.docService.toBuilder() : null;
        }

        @Override
        public final Builder docService(ServiceEndpoint docService) {
            this.docService = docService;
            return this;
        }

        public final void setDocService(ServiceEndpoint.BuilderImpl docService) {
            this.docService = docService != null ? docService.build() : null;
        }

        public final ServiceEndpoint.Builder getSearchService() {
            return this.searchService != null ? this.searchService.toBuilder() : null;
        }

        @Override
        public final Builder searchService(ServiceEndpoint searchService) {
            this.searchService = searchService;
            return this;
        }

        public final void setSearchService(ServiceEndpoint.BuilderImpl searchService) {
            this.searchService = searchService != null ? searchService.build() : null;
        }

        public final Boolean getRequiresIndexDocuments() {
            return this.requiresIndexDocuments;
        }

        @Override
        public final Builder requiresIndexDocuments(Boolean requiresIndexDocuments) {
            this.requiresIndexDocuments = requiresIndexDocuments;
            return this;
        }

        public final void setRequiresIndexDocuments(Boolean requiresIndexDocuments) {
            this.requiresIndexDocuments = requiresIndexDocuments;
        }

        public final Boolean getProcessing() {
            return this.processing;
        }

        @Override
        public final Builder processing(Boolean processing) {
            this.processing = processing;
            return this;
        }

        public final void setProcessing(Boolean processing) {
            this.processing = processing;
        }

        public final String getSearchInstanceType() {
            return this.searchInstanceType;
        }

        @Override
        public final Builder searchInstanceType(String searchInstanceType) {
            this.searchInstanceType = searchInstanceType;
            return this;
        }

        public final void setSearchInstanceType(String searchInstanceType) {
            this.searchInstanceType = searchInstanceType;
        }

        public final Integer getSearchPartitionCount() {
            return this.searchPartitionCount;
        }

        @Override
        public final Builder searchPartitionCount(Integer searchPartitionCount) {
            this.searchPartitionCount = searchPartitionCount;
            return this;
        }

        public final void setSearchPartitionCount(Integer searchPartitionCount) {
            this.searchPartitionCount = searchPartitionCount;
        }

        public final Integer getSearchInstanceCount() {
            return this.searchInstanceCount;
        }

        @Override
        public final Builder searchInstanceCount(Integer searchInstanceCount) {
            this.searchInstanceCount = searchInstanceCount;
            return this;
        }

        public final void setSearchInstanceCount(Integer searchInstanceCount) {
            this.searchInstanceCount = searchInstanceCount;
        }

        public final Limits.Builder getLimits() {
            return this.limits != null ? this.limits.toBuilder() : null;
        }

        @Override
        public final Builder limits(Limits limits) {
            this.limits = limits;
            return this;
        }

        public final void setLimits(Limits.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        public DomainStatus build() {
            return new DomainStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DomainStatus> {
        public Builder domainId(String var1);

        public Builder domainName(String var1);

        public Builder arn(String var1);

        public Builder created(Boolean var1);

        public Builder deleted(Boolean var1);

        public Builder docService(ServiceEndpoint var1);

        default public Builder docService(Consumer<ServiceEndpoint.Builder> docService) {
            return this.docService((ServiceEndpoint)((ServiceEndpoint.Builder)ServiceEndpoint.builder().applyMutation(docService)).build());
        }

        public Builder searchService(ServiceEndpoint var1);

        default public Builder searchService(Consumer<ServiceEndpoint.Builder> searchService) {
            return this.searchService((ServiceEndpoint)((ServiceEndpoint.Builder)ServiceEndpoint.builder().applyMutation(searchService)).build());
        }

        public Builder requiresIndexDocuments(Boolean var1);

        public Builder processing(Boolean var1);

        public Builder searchInstanceType(String var1);

        public Builder searchPartitionCount(Integer var1);

        public Builder searchInstanceCount(Integer var1);

        public Builder limits(Limits var1);

        default public Builder limits(Consumer<Limits.Builder> limits) {
            return this.limits((Limits)((Limits.Builder)Limits.builder().applyMutation(limits)).build());
        }
    }
}

