/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchRequest;
import software.amazon.awssdk.services.cloudsearch.model.DomainNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDomainsRequest
extends CloudSearchRequest
implements ToCopyableBuilder<Builder, DescribeDomainsRequest> {
    private final List<String> domainNames;

    private DescribeDomainsRequest(BuilderImpl builder) {
        super(builder);
        this.domainNames = builder.domainNames;
    }

    public List<String> domainNames() {
        return this.domainNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainsRequest)) {
            return false;
        }
        DescribeDomainsRequest other = (DescribeDomainsRequest)((Object)obj);
        return Objects.equals(this.domainNames(), other.domainNames());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDomainsRequest").add("DomainNames", this.domainNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainNames": {
                return Optional.ofNullable(clazz.cast(this.domainNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudSearchRequest.BuilderImpl
    implements Builder {
        private List<String> domainNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainsRequest model) {
            super(model);
            this.domainNames(model.domainNames);
        }

        public final Collection<String> getDomainNames() {
            return this.domainNames;
        }

        @Override
        public final Builder domainNames(Collection<String> domainNames) {
            this.domainNames = DomainNameListCopier.copy(domainNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainNames(String ... domainNames) {
            this.domainNames(Arrays.asList(domainNames));
            return this;
        }

        public final void setDomainNames(Collection<String> domainNames) {
            this.domainNames = DomainNameListCopier.copy(domainNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDomainsRequest build() {
            return new DescribeDomainsRequest(this);
        }
    }

    public static interface Builder
    extends CloudSearchRequest.Builder,
    CopyableBuilder<Builder, DescribeDomainsRequest> {
        public Builder domainNames(Collection<String> var1);

        public Builder domainNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

