/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudsearch.model.Limits;

public class LimitsUnmarshaller
implements Unmarshaller<Limits, StaxUnmarshallerContext> {
    private static final LimitsUnmarshaller INSTANCE = new LimitsUnmarshaller();

    public Limits unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Limits.Builder limits = Limits.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("MaximumReplicationCount", targetDepth)) {
                    limits.maximumReplicationCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("MaximumPartitionCount", targetDepth)) continue;
                limits.maximumPartitionCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Limits)limits.build();
    }

    public static LimitsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

