/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudsearch.model.AnalysisOptions;

public class AnalysisOptionsUnmarshaller
implements Unmarshaller<AnalysisOptions, StaxUnmarshallerContext> {
    private static final AnalysisOptionsUnmarshaller INSTANCE = new AnalysisOptionsUnmarshaller();

    public AnalysisOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        AnalysisOptions.Builder analysisOptions = AnalysisOptions.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Synonyms", targetDepth)) {
                    analysisOptions.synonyms(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Stopwords", targetDepth)) {
                    analysisOptions.stopwords(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StemmingDictionary", targetDepth)) {
                    analysisOptions.stemmingDictionary(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("JapaneseTokenizationDictionary", targetDepth)) {
                    analysisOptions.japaneseTokenizationDictionary(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("AlgorithmicStemming", targetDepth)) continue;
                analysisOptions.algorithmicStemming(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (AnalysisOptions)analysisOptions.build();
    }

    public static AnalysisOptionsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

