/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.model.FieldStats;

@SdkInternalApi
public class FieldStatsMarshaller {
    private static final MarshallingInfo<String> MIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("min").build();
    private static final MarshallingInfo<String> MAX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("max").build();
    private static final MarshallingInfo<Long> COUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("count").build();
    private static final MarshallingInfo<Long> MISSING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("missing").build();
    private static final MarshallingInfo<Double> SUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sum").build();
    private static final MarshallingInfo<Double> SUMOFSQUARES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sumOfSquares").build();
    private static final MarshallingInfo<String> MEAN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mean").build();
    private static final MarshallingInfo<Double> STDDEV_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stddev").build();
    private static final FieldStatsMarshaller instance = new FieldStatsMarshaller();

    public static FieldStatsMarshaller getInstance() {
        return instance;
    }

    public void marshall(FieldStats fieldStats, ProtocolMarshaller protocolMarshaller) {
        if (fieldStats == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)fieldStats.min(), MIN_BINDING);
            protocolMarshaller.marshall((Object)fieldStats.max(), MAX_BINDING);
            protocolMarshaller.marshall((Object)fieldStats.count(), COUNT_BINDING);
            protocolMarshaller.marshall((Object)fieldStats.missing(), MISSING_BINDING);
            protocolMarshaller.marshall((Object)fieldStats.sum(), SUM_BINDING);
            protocolMarshaller.marshall((Object)fieldStats.sumOfSquares(), SUMOFSQUARES_BINDING);
            protocolMarshaller.marshall((Object)fieldStats.mean(), MEAN_BINDING);
            protocolMarshaller.marshall((Object)fieldStats.stddev(), STDDEV_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

