/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudsearchdomain.model.Bucket;
import software.amazon.awssdk.services.cloudsearchdomain.model.BucketListCopier;
import software.amazon.awssdk.services.cloudsearchdomain.transform.BucketInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BucketInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, BucketInfo> {
    private final List<Bucket> buckets;

    private BucketInfo(BuilderImpl builder) {
        this.buckets = builder.buckets;
    }

    public List<Bucket> buckets() {
        return this.buckets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.buckets() == null ? 0 : this.buckets().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketInfo)) {
            return false;
        }
        BucketInfo other = (BucketInfo)obj;
        if (other.buckets() == null ^ this.buckets() == null) {
            return false;
        }
        return other.buckets() == null || other.buckets().equals(this.buckets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.buckets() != null) {
            sb.append("Buckets: ").append(this.buckets()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BucketInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Bucket> buckets = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(BucketInfo model) {
            this.setBuckets(model.buckets);
        }

        public final Collection<Bucket> getBuckets() {
            return this.buckets;
        }

        @Override
        public final Builder buckets(Collection<Bucket> buckets) {
            this.buckets = BucketListCopier.copy(buckets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buckets(Bucket ... buckets) {
            if (this.buckets == null) {
                this.buckets = new SdkInternalList(buckets.length);
            }
            for (Bucket e : buckets) {
                this.buckets.add(e);
            }
            return this;
        }

        public final void setBuckets(Collection<Bucket> buckets) {
            this.buckets = BucketListCopier.copy(buckets);
        }

        @SafeVarargs
        public final void setBuckets(Bucket ... buckets) {
            if (this.buckets == null) {
                this.buckets = new SdkInternalList(buckets.length);
            }
            for (Bucket e : buckets) {
                this.buckets.add(e);
            }
        }

        public BucketInfo build() {
            return new BucketInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BucketInfo> {
        public Builder buckets(Collection<Bucket> var1);

        public Builder buckets(Bucket ... var1);
    }
}

