/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudsearch.model.DescribeExpressionsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeExpressionsRequestMarshaller
implements Marshaller<Request<DescribeExpressionsRequest>, DescribeExpressionsRequest> {
    public Request<DescribeExpressionsRequest> marshall(DescribeExpressionsRequest describeExpressionsRequest) {
        SdkInternalList expressionNamesList;
        if (describeExpressionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeExpressionsRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeExpressions");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeExpressionsRequest.domainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)describeExpressionsRequest.domainName()));
        }
        if (!(expressionNamesList = (SdkInternalList)describeExpressionsRequest.expressionNames()).isEmpty() || !expressionNamesList.isAutoConstruct()) {
            int expressionNamesListIndex = 1;
            for (String expressionNamesListValue : expressionNamesList) {
                if (expressionNamesListValue != null) {
                    request.addParameter("ExpressionNames.member." + expressionNamesListIndex, StringUtils.fromString((String)expressionNamesListValue));
                }
                ++expressionNamesListIndex;
            }
        }
        if (describeExpressionsRequest.deployed() != null) {
            request.addParameter("Deployed", StringUtils.fromBoolean((Boolean)describeExpressionsRequest.deployed()));
        }
        return request;
    }
}

