/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudsearch.model.StandardNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSuggestersRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeSuggestersRequest> {
    private final String domainName;
    private final List<String> suggesterNames;
    private final Boolean deployed;

    private DescribeSuggestersRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.suggesterNames = builder.suggesterNames;
        this.deployed = builder.deployed;
    }

    public String domainName() {
        return this.domainName;
    }

    public List<String> suggesterNames() {
        return this.suggesterNames;
    }

    public Boolean deployed() {
        return this.deployed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.suggesterNames() == null ? 0 : this.suggesterNames().hashCode());
        hashCode = 31 * hashCode + (this.deployed() == null ? 0 : this.deployed().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSuggestersRequest)) {
            return false;
        }
        DescribeSuggestersRequest other = (DescribeSuggestersRequest)((Object)obj);
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.suggesterNames() == null ^ this.suggesterNames() == null) {
            return false;
        }
        if (other.suggesterNames() != null && !other.suggesterNames().equals(this.suggesterNames())) {
            return false;
        }
        if (other.deployed() == null ^ this.deployed() == null) {
            return false;
        }
        return other.deployed() == null || other.deployed().equals(this.deployed());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.suggesterNames() != null) {
            sb.append("SuggesterNames: ").append(this.suggesterNames()).append(",");
        }
        if (this.deployed() != null) {
            sb.append("Deployed: ").append(this.deployed()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String domainName;
        private List<String> suggesterNames = new SdkInternalList();
        private Boolean deployed;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSuggestersRequest model) {
            this.setDomainName(model.domainName);
            this.setSuggesterNames(model.suggesterNames);
            this.setDeployed(model.deployed);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<String> getSuggesterNames() {
            return this.suggesterNames;
        }

        @Override
        public final Builder suggesterNames(Collection<String> suggesterNames) {
            this.suggesterNames = StandardNameListCopier.copy(suggesterNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggesterNames(String ... suggesterNames) {
            if (this.suggesterNames == null) {
                this.suggesterNames = new SdkInternalList(suggesterNames.length);
            }
            for (String e : suggesterNames) {
                this.suggesterNames.add(e);
            }
            return this;
        }

        public final void setSuggesterNames(Collection<String> suggesterNames) {
            this.suggesterNames = StandardNameListCopier.copy(suggesterNames);
        }

        @SafeVarargs
        public final void setSuggesterNames(String ... suggesterNames) {
            if (this.suggesterNames == null) {
                this.suggesterNames = new SdkInternalList(suggesterNames.length);
            }
            for (String e : suggesterNames) {
                this.suggesterNames.add(e);
            }
        }

        public final Boolean getDeployed() {
            return this.deployed;
        }

        @Override
        public final Builder deployed(Boolean deployed) {
            this.deployed = deployed;
            return this;
        }

        public final void setDeployed(Boolean deployed) {
            this.deployed = deployed;
        }

        public DescribeSuggestersRequest build() {
            return new DescribeSuggestersRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSuggestersRequest> {
        public Builder domainName(String var1);

        public Builder suggesterNames(Collection<String> var1);

        public Builder suggesterNames(String ... var1);

        public Builder deployed(Boolean var1);
    }
}

