/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudsearch.model.DynamicFieldNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeIndexFieldsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeIndexFieldsRequest> {
    private final String domainName;
    private final List<String> fieldNames;
    private final Boolean deployed;

    private DescribeIndexFieldsRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.fieldNames = builder.fieldNames;
        this.deployed = builder.deployed;
    }

    public String domainName() {
        return this.domainName;
    }

    public List<String> fieldNames() {
        return this.fieldNames;
    }

    public Boolean deployed() {
        return this.deployed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.fieldNames() == null ? 0 : this.fieldNames().hashCode());
        hashCode = 31 * hashCode + (this.deployed() == null ? 0 : this.deployed().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIndexFieldsRequest)) {
            return false;
        }
        DescribeIndexFieldsRequest other = (DescribeIndexFieldsRequest)((Object)obj);
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.fieldNames() == null ^ this.fieldNames() == null) {
            return false;
        }
        if (other.fieldNames() != null && !other.fieldNames().equals(this.fieldNames())) {
            return false;
        }
        if (other.deployed() == null ^ this.deployed() == null) {
            return false;
        }
        return other.deployed() == null || other.deployed().equals(this.deployed());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.fieldNames() != null) {
            sb.append("FieldNames: ").append(this.fieldNames()).append(",");
        }
        if (this.deployed() != null) {
            sb.append("Deployed: ").append(this.deployed()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String domainName;
        private List<String> fieldNames = new SdkInternalList();
        private Boolean deployed;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIndexFieldsRequest model) {
            this.setDomainName(model.domainName);
            this.setFieldNames(model.fieldNames);
            this.setDeployed(model.deployed);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<String> getFieldNames() {
            return this.fieldNames;
        }

        @Override
        public final Builder fieldNames(Collection<String> fieldNames) {
            this.fieldNames = DynamicFieldNameListCopier.copy(fieldNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldNames(String ... fieldNames) {
            if (this.fieldNames == null) {
                this.fieldNames = new SdkInternalList(fieldNames.length);
            }
            for (String e : fieldNames) {
                this.fieldNames.add(e);
            }
            return this;
        }

        public final void setFieldNames(Collection<String> fieldNames) {
            this.fieldNames = DynamicFieldNameListCopier.copy(fieldNames);
        }

        @SafeVarargs
        public final void setFieldNames(String ... fieldNames) {
            if (this.fieldNames == null) {
                this.fieldNames = new SdkInternalList(fieldNames.length);
            }
            for (String e : fieldNames) {
                this.fieldNames.add(e);
            }
        }

        public final Boolean getDeployed() {
            return this.deployed;
        }

        @Override
        public final Builder deployed(Boolean deployed) {
            this.deployed = deployed;
            return this;
        }

        public final void setDeployed(Boolean deployed) {
            this.deployed = deployed;
        }

        public DescribeIndexFieldsRequest build() {
            return new DescribeIndexFieldsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeIndexFieldsRequest> {
        public Builder domainName(String var1);

        public Builder fieldNames(Collection<String> var1);

        public Builder fieldNames(String ... var1);

        public Builder deployed(Boolean var1);
    }
}

