/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudsearch.model.ExpressionStatus;
import software.amazon.awssdk.services.cloudsearch.model.ExpressionStatusListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeExpressionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeExpressionsResponse> {
    private final List<ExpressionStatus> expressions;

    private DescribeExpressionsResponse(BuilderImpl builder) {
        this.expressions = builder.expressions;
    }

    public List<ExpressionStatus> expressions() {
        return this.expressions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.expressions() == null ? 0 : this.expressions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExpressionsResponse)) {
            return false;
        }
        DescribeExpressionsResponse other = (DescribeExpressionsResponse)((Object)obj);
        if (other.expressions() == null ^ this.expressions() == null) {
            return false;
        }
        return other.expressions() == null || other.expressions().equals(this.expressions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.expressions() != null) {
            sb.append("Expressions: ").append(this.expressions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ExpressionStatus> expressions = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExpressionsResponse model) {
            this.setExpressions(model.expressions);
        }

        public final Collection<ExpressionStatus> getExpressions() {
            return this.expressions;
        }

        @Override
        public final Builder expressions(Collection<ExpressionStatus> expressions) {
            this.expressions = ExpressionStatusListCopier.copy(expressions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expressions(ExpressionStatus ... expressions) {
            if (this.expressions == null) {
                this.expressions = new SdkInternalList(expressions.length);
            }
            for (ExpressionStatus e : expressions) {
                this.expressions.add(e);
            }
            return this;
        }

        public final void setExpressions(Collection<ExpressionStatus> expressions) {
            this.expressions = ExpressionStatusListCopier.copy(expressions);
        }

        @SafeVarargs
        public final void setExpressions(ExpressionStatus ... expressions) {
            if (this.expressions == null) {
                this.expressions = new SdkInternalList(expressions.length);
            }
            for (ExpressionStatus e : expressions) {
                this.expressions.add(e);
            }
        }

        public DescribeExpressionsResponse build() {
            return new DescribeExpressionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeExpressionsResponse> {
        public Builder expressions(Collection<ExpressionStatus> var1);

        public Builder expressions(ExpressionStatus ... var1);
    }
}

