/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudsearch.model.StandardNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeExpressionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeExpressionsRequest> {
    private final String domainName;
    private final List<String> expressionNames;
    private final Boolean deployed;

    private DescribeExpressionsRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.expressionNames = builder.expressionNames;
        this.deployed = builder.deployed;
    }

    public String domainName() {
        return this.domainName;
    }

    public List<String> expressionNames() {
        return this.expressionNames;
    }

    public Boolean deployed() {
        return this.deployed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.expressionNames() == null ? 0 : this.expressionNames().hashCode());
        hashCode = 31 * hashCode + (this.deployed() == null ? 0 : this.deployed().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExpressionsRequest)) {
            return false;
        }
        DescribeExpressionsRequest other = (DescribeExpressionsRequest)((Object)obj);
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.expressionNames() == null ^ this.expressionNames() == null) {
            return false;
        }
        if (other.expressionNames() != null && !other.expressionNames().equals(this.expressionNames())) {
            return false;
        }
        if (other.deployed() == null ^ this.deployed() == null) {
            return false;
        }
        return other.deployed() == null || other.deployed().equals(this.deployed());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.expressionNames() != null) {
            sb.append("ExpressionNames: ").append(this.expressionNames()).append(",");
        }
        if (this.deployed() != null) {
            sb.append("Deployed: ").append(this.deployed()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String domainName;
        private List<String> expressionNames = new SdkInternalList();
        private Boolean deployed;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExpressionsRequest model) {
            this.setDomainName(model.domainName);
            this.setExpressionNames(model.expressionNames);
            this.setDeployed(model.deployed);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<String> getExpressionNames() {
            return this.expressionNames;
        }

        @Override
        public final Builder expressionNames(Collection<String> expressionNames) {
            this.expressionNames = StandardNameListCopier.copy(expressionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expressionNames(String ... expressionNames) {
            if (this.expressionNames == null) {
                this.expressionNames = new SdkInternalList(expressionNames.length);
            }
            for (String e : expressionNames) {
                this.expressionNames.add(e);
            }
            return this;
        }

        public final void setExpressionNames(Collection<String> expressionNames) {
            this.expressionNames = StandardNameListCopier.copy(expressionNames);
        }

        @SafeVarargs
        public final void setExpressionNames(String ... expressionNames) {
            if (this.expressionNames == null) {
                this.expressionNames = new SdkInternalList(expressionNames.length);
            }
            for (String e : expressionNames) {
                this.expressionNames.add(e);
            }
        }

        public final Boolean getDeployed() {
            return this.deployed;
        }

        @Override
        public final Builder deployed(Boolean deployed) {
            this.deployed = deployed;
            return this;
        }

        public final void setDeployed(Boolean deployed) {
            this.deployed = deployed;
        }

        public DescribeExpressionsRequest build() {
            return new DescribeExpressionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeExpressionsRequest> {
        public Builder domainName(String var1);

        public Builder expressionNames(Collection<String> var1);

        public Builder expressionNames(String ... var1);

        public Builder deployed(Boolean var1);
    }
}

