/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudhsmv2.CloudHsmV2Client;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsResponse;

public class DescribeBackupsIterable
implements SdkIterable<DescribeBackupsResponse> {
    private final CloudHsmV2Client client;
    private final DescribeBackupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeBackupsIterable(CloudHsmV2Client client, DescribeBackupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeBackupsResponseFetcher();
    }

    public Iterator<DescribeBackupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeBackupsResponseFetcher
    implements SyncPageFetcher<DescribeBackupsResponse> {
        private DescribeBackupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBackupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeBackupsResponse nextPage(DescribeBackupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeBackupsIterable.this.client.describeBackups(DescribeBackupsIterable.this.firstRequest);
            }
            return DescribeBackupsIterable.this.client.describeBackups((DescribeBackupsRequest)((Object)DescribeBackupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

