/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Certificates
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Certificates> {
    private static final SdkField<String> CLUSTER_CSR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterCsr").getter(Certificates.getter(Certificates::clusterCsr)).setter(Certificates.setter(Builder::clusterCsr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterCsr").build()}).build();
    private static final SdkField<String> HSM_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsmCertificate").getter(Certificates.getter(Certificates::hsmCertificate)).setter(Certificates.setter(Builder::hsmCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmCertificate").build()}).build();
    private static final SdkField<String> AWS_HARDWARE_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsHardwareCertificate").getter(Certificates.getter(Certificates::awsHardwareCertificate)).setter(Certificates.setter(Builder::awsHardwareCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsHardwareCertificate").build()}).build();
    private static final SdkField<String> MANUFACTURER_HARDWARE_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManufacturerHardwareCertificate").getter(Certificates.getter(Certificates::manufacturerHardwareCertificate)).setter(Certificates.setter(Builder::manufacturerHardwareCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManufacturerHardwareCertificate").build()}).build();
    private static final SdkField<String> CLUSTER_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterCertificate").getter(Certificates.getter(Certificates::clusterCertificate)).setter(Certificates.setter(Builder::clusterCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterCertificate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_CSR_FIELD, HSM_CERTIFICATE_FIELD, AWS_HARDWARE_CERTIFICATE_FIELD, MANUFACTURER_HARDWARE_CERTIFICATE_FIELD, CLUSTER_CERTIFICATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Certificates.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clusterCsr;
    private final String hsmCertificate;
    private final String awsHardwareCertificate;
    private final String manufacturerHardwareCertificate;
    private final String clusterCertificate;

    private Certificates(BuilderImpl builder) {
        this.clusterCsr = builder.clusterCsr;
        this.hsmCertificate = builder.hsmCertificate;
        this.awsHardwareCertificate = builder.awsHardwareCertificate;
        this.manufacturerHardwareCertificate = builder.manufacturerHardwareCertificate;
        this.clusterCertificate = builder.clusterCertificate;
    }

    public final String clusterCsr() {
        return this.clusterCsr;
    }

    public final String hsmCertificate() {
        return this.hsmCertificate;
    }

    public final String awsHardwareCertificate() {
        return this.awsHardwareCertificate;
    }

    public final String manufacturerHardwareCertificate() {
        return this.manufacturerHardwareCertificate;
    }

    public final String clusterCertificate() {
        return this.clusterCertificate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterCsr());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsHardwareCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.manufacturerHardwareCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterCertificate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Certificates)) {
            return false;
        }
        Certificates other = (Certificates)obj;
        return Objects.equals(this.clusterCsr(), other.clusterCsr()) && Objects.equals(this.hsmCertificate(), other.hsmCertificate()) && Objects.equals(this.awsHardwareCertificate(), other.awsHardwareCertificate()) && Objects.equals(this.manufacturerHardwareCertificate(), other.manufacturerHardwareCertificate()) && Objects.equals(this.clusterCertificate(), other.clusterCertificate());
    }

    public final String toString() {
        return ToString.builder((String)"Certificates").add("ClusterCsr", (Object)this.clusterCsr()).add("HsmCertificate", (Object)this.hsmCertificate()).add("AwsHardwareCertificate", (Object)this.awsHardwareCertificate()).add("ManufacturerHardwareCertificate", (Object)this.manufacturerHardwareCertificate()).add("ClusterCertificate", (Object)this.clusterCertificate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterCsr": {
                return Optional.ofNullable(clazz.cast(this.clusterCsr()));
            }
            case "HsmCertificate": {
                return Optional.ofNullable(clazz.cast(this.hsmCertificate()));
            }
            case "AwsHardwareCertificate": {
                return Optional.ofNullable(clazz.cast(this.awsHardwareCertificate()));
            }
            case "ManufacturerHardwareCertificate": {
                return Optional.ofNullable(clazz.cast(this.manufacturerHardwareCertificate()));
            }
            case "ClusterCertificate": {
                return Optional.ofNullable(clazz.cast(this.clusterCertificate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ClusterCsr", CLUSTER_CSR_FIELD);
        map.put("HsmCertificate", HSM_CERTIFICATE_FIELD);
        map.put("AwsHardwareCertificate", AWS_HARDWARE_CERTIFICATE_FIELD);
        map.put("ManufacturerHardwareCertificate", MANUFACTURER_HARDWARE_CERTIFICATE_FIELD);
        map.put("ClusterCertificate", CLUSTER_CERTIFICATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Certificates, T> g) {
        return obj -> g.apply((Certificates)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterCsr;
        private String hsmCertificate;
        private String awsHardwareCertificate;
        private String manufacturerHardwareCertificate;
        private String clusterCertificate;

        private BuilderImpl() {
        }

        private BuilderImpl(Certificates model) {
            this.clusterCsr(model.clusterCsr);
            this.hsmCertificate(model.hsmCertificate);
            this.awsHardwareCertificate(model.awsHardwareCertificate);
            this.manufacturerHardwareCertificate(model.manufacturerHardwareCertificate);
            this.clusterCertificate(model.clusterCertificate);
        }

        public final String getClusterCsr() {
            return this.clusterCsr;
        }

        public final void setClusterCsr(String clusterCsr) {
            this.clusterCsr = clusterCsr;
        }

        @Override
        public final Builder clusterCsr(String clusterCsr) {
            this.clusterCsr = clusterCsr;
            return this;
        }

        public final String getHsmCertificate() {
            return this.hsmCertificate;
        }

        public final void setHsmCertificate(String hsmCertificate) {
            this.hsmCertificate = hsmCertificate;
        }

        @Override
        public final Builder hsmCertificate(String hsmCertificate) {
            this.hsmCertificate = hsmCertificate;
            return this;
        }

        public final String getAwsHardwareCertificate() {
            return this.awsHardwareCertificate;
        }

        public final void setAwsHardwareCertificate(String awsHardwareCertificate) {
            this.awsHardwareCertificate = awsHardwareCertificate;
        }

        @Override
        public final Builder awsHardwareCertificate(String awsHardwareCertificate) {
            this.awsHardwareCertificate = awsHardwareCertificate;
            return this;
        }

        public final String getManufacturerHardwareCertificate() {
            return this.manufacturerHardwareCertificate;
        }

        public final void setManufacturerHardwareCertificate(String manufacturerHardwareCertificate) {
            this.manufacturerHardwareCertificate = manufacturerHardwareCertificate;
        }

        @Override
        public final Builder manufacturerHardwareCertificate(String manufacturerHardwareCertificate) {
            this.manufacturerHardwareCertificate = manufacturerHardwareCertificate;
            return this;
        }

        public final String getClusterCertificate() {
            return this.clusterCertificate;
        }

        public final void setClusterCertificate(String clusterCertificate) {
            this.clusterCertificate = clusterCertificate;
        }

        @Override
        public final Builder clusterCertificate(String clusterCertificate) {
            this.clusterCertificate = clusterCertificate;
            return this;
        }

        public Certificates build() {
            return new Certificates(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Certificates> {
        public Builder clusterCsr(String var1);

        public Builder hsmCertificate(String var1);

        public Builder awsHardwareCertificate(String var1);

        public Builder manufacturerHardwareCertificate(String var1);

        public Builder clusterCertificate(String var1);
    }
}

