/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmV2Request;
import software.amazon.awssdk.services.cloudhsmv2.model.TagKeyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UntagResourceRequest
extends CloudHsmV2Request
implements ToCopyableBuilder<Builder, UntagResourceRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(UntagResourceRequest.getter(UntagResourceRequest::resourceId)).setter(UntagResourceRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<List<String>> TAG_KEY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagKeyList").getter(UntagResourceRequest.getter(UntagResourceRequest::tagKeyList)).setter(UntagResourceRequest.setter(Builder::tagKeyList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKeyList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, TAG_KEY_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UntagResourceRequest.memberNameToFieldInitializer();
    private final String resourceId;
    private final List<String> tagKeyList;

    private UntagResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.tagKeyList = builder.tagKeyList;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final boolean hasTagKeyList() {
        return this.tagKeyList != null && !(this.tagKeyList instanceof SdkAutoConstructList);
    }

    public final List<String> tagKeyList() {
        return this.tagKeyList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagKeyList() ? this.tagKeyList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagResourceRequest)) {
            return false;
        }
        UntagResourceRequest other = (UntagResourceRequest)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && this.hasTagKeyList() == other.hasTagKeyList() && Objects.equals(this.tagKeyList(), other.tagKeyList());
    }

    public final String toString() {
        return ToString.builder((String)"UntagResourceRequest").add("ResourceId", (Object)this.resourceId()).add("TagKeyList", this.hasTagKeyList() ? this.tagKeyList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "TagKeyList": {
                return Optional.ofNullable(clazz.cast(this.tagKeyList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("TagKeyList", TAG_KEY_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UntagResourceRequest, T> g) {
        return obj -> g.apply((UntagResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmV2Request.BuilderImpl
    implements Builder {
        private String resourceId;
        private List<String> tagKeyList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UntagResourceRequest model) {
            super(model);
            this.resourceId(model.resourceId);
            this.tagKeyList(model.tagKeyList);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final Collection<String> getTagKeyList() {
            if (this.tagKeyList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagKeyList;
        }

        public final void setTagKeyList(Collection<String> tagKeyList) {
            this.tagKeyList = TagKeyListCopier.copy(tagKeyList);
        }

        @Override
        public final Builder tagKeyList(Collection<String> tagKeyList) {
            this.tagKeyList = TagKeyListCopier.copy(tagKeyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeyList(String ... tagKeyList) {
            this.tagKeyList(Arrays.asList(tagKeyList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UntagResourceRequest build() {
            return new UntagResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudHsmV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UntagResourceRequest> {
        public Builder resourceId(String var1);

        public Builder tagKeyList(Collection<String> var1);

        public Builder tagKeyList(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

