/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmV2Request;
import software.amazon.awssdk.services.cloudhsmv2.model.FiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBackupsRequest
extends CloudHsmV2Request
implements ToCopyableBuilder<Builder, DescribeBackupsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeBackupsRequest.getter(DescribeBackupsRequest::nextToken)).setter(DescribeBackupsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeBackupsRequest.getter(DescribeBackupsRequest::maxResults)).setter(DescribeBackupsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<Map<String, List<String>>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Filters").getter(DescribeBackupsRequest.getter(DescribeBackupsRequest::filters)).setter(DescribeBackupsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Boolean> SHARED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Shared").getter(DescribeBackupsRequest.getter(DescribeBackupsRequest::shared)).setter(DescribeBackupsRequest.setter(Builder::shared)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Shared").build()}).build();
    private static final SdkField<Boolean> SORT_ASCENDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SortAscending").getter(DescribeBackupsRequest.getter(DescribeBackupsRequest::sortAscending)).setter(DescribeBackupsRequest.setter(Builder::sortAscending)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortAscending").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTERS_FIELD, SHARED_FIELD, SORT_ASCENDING_FIELD));
    private final String nextToken;
    private final Integer maxResults;
    private final Map<String, List<String>> filters;
    private final Boolean shared;
    private final Boolean sortAscending;

    private DescribeBackupsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
        this.shared = builder.shared;
        this.sortAscending = builder.sortAscending;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> filters() {
        return this.filters;
    }

    public final Boolean shared() {
        return this.shared;
    }

    public final Boolean sortAscending() {
        return this.sortAscending;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.shared());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortAscending());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBackupsRequest)) {
            return false;
        }
        DescribeBackupsRequest other = (DescribeBackupsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.shared(), other.shared()) && Objects.equals(this.sortAscending(), other.sortAscending());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeBackupsRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("Filters", this.hasFilters() ? this.filters() : null).add("Shared", (Object)this.shared()).add("SortAscending", (Object)this.sortAscending()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "Shared": {
                return Optional.ofNullable(clazz.cast(this.shared()));
            }
            case "SortAscending": {
                return Optional.ofNullable(clazz.cast(this.sortAscending()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBackupsRequest, T> g) {
        return obj -> g.apply((DescribeBackupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmV2Request.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private Map<String, List<String>> filters = DefaultSdkAutoConstructMap.getInstance();
        private Boolean shared;
        private Boolean sortAscending;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBackupsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.filters(model.filters);
            this.shared(model.shared);
            this.sortAscending(model.sortAscending);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getFilters() {
            if (this.filters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.filters;
        }

        public final void setFilters(Map<String, ? extends Collection<String>> filters) {
            this.filters = FiltersCopier.copy(filters);
        }

        @Override
        public final Builder filters(Map<String, ? extends Collection<String>> filters) {
            this.filters = FiltersCopier.copy(filters);
            return this;
        }

        public final Boolean getShared() {
            return this.shared;
        }

        public final void setShared(Boolean shared) {
            this.shared = shared;
        }

        @Override
        public final Builder shared(Boolean shared) {
            this.shared = shared;
            return this;
        }

        public final Boolean getSortAscending() {
            return this.sortAscending;
        }

        public final void setSortAscending(Boolean sortAscending) {
            this.sortAscending = sortAscending;
        }

        @Override
        public final Builder sortAscending(Boolean sortAscending) {
            this.sortAscending = sortAscending;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeBackupsRequest build() {
            return new DescribeBackupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudHsmV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBackupsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder filters(Map<String, ? extends Collection<String>> var1);

        public Builder shared(Boolean var1);

        public Builder sortAscending(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

