/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClustersResponse extends CloudHsmV2Response implements
        ToCopyableBuilder<DescribeClustersResponse.Builder, DescribeClustersResponse> {
    private static final SdkField<List<Cluster>> CLUSTERS_FIELD = SdkField
            .<List<Cluster>> builder(MarshallingType.LIST)
            .memberName("Clusters")
            .getter(getter(DescribeClustersResponse::clusters))
            .setter(setter(Builder::clusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Clusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Cluster> builder(MarshallingType.SDK_POJO)
                                            .constructor(Cluster::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeClustersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Cluster> clusters;

    private final String nextToken;

    private DescribeClustersResponse(BuilderImpl builder) {
        super(builder);
        this.clusters = builder.clusters;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Clusters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasClusters() {
        return clusters != null && !(clusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of clusters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasClusters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of clusters.
     */
    public final List<Cluster> clusters() {
        return clusters;
    }

    /**
     * <p>
     * An opaque string that indicates that the response contains only a subset of clusters. Use this value in a
     * subsequent <code>DescribeClusters</code> request to get more clusters.
     * </p>
     * 
     * @return An opaque string that indicates that the response contains only a subset of clusters. Use this value in a
     *         subsequent <code>DescribeClusters</code> request to get more clusters.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasClusters() ? clusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClustersResponse)) {
            return false;
        }
        DescribeClustersResponse other = (DescribeClustersResponse) obj;
        return hasClusters() == other.hasClusters() && Objects.equals(clusters(), other.clusters())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClustersResponse").add("Clusters", hasClusters() ? clusters() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Clusters":
            return Optional.ofNullable(clazz.cast(clusters()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClustersResponse, T> g) {
        return obj -> g.apply((DescribeClustersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmV2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClustersResponse> {
        /**
         * <p>
         * A list of clusters.
         * </p>
         * 
         * @param clusters
         *        A list of clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(Collection<Cluster> clusters);

        /**
         * <p>
         * A list of clusters.
         * </p>
         * 
         * @param clusters
         *        A list of clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(Cluster... clusters);

        /**
         * <p>
         * A list of clusters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Cluster>.Builder} avoiding the need to
         * create one manually via {@link List<Cluster>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Cluster>.Builder#build()} is called immediately and its
         * result is passed to {@link #clusters(List<Cluster>)}.
         * 
         * @param clusters
         *        a consumer that will call methods on {@link List<Cluster>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusters(List<Cluster>)
         */
        Builder clusters(Consumer<Cluster.Builder>... clusters);

        /**
         * <p>
         * An opaque string that indicates that the response contains only a subset of clusters. Use this value in a
         * subsequent <code>DescribeClusters</code> request to get more clusters.
         * </p>
         * 
         * @param nextToken
         *        An opaque string that indicates that the response contains only a subset of clusters. Use this value
         *        in a subsequent <code>DescribeClusters</code> request to get more clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudHsmV2Response.BuilderImpl implements Builder {
        private List<Cluster> clusters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClustersResponse model) {
            super(model);
            clusters(model.clusters);
            nextToken(model.nextToken);
        }

        public final Collection<Cluster.Builder> getClusters() {
            if (clusters instanceof SdkAutoConstructList) {
                return null;
            }
            return clusters != null ? clusters.stream().map(Cluster::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusters(Collection<Cluster> clusters) {
            this.clusters = ClustersCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(Cluster... clusters) {
            clusters(Arrays.asList(clusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(Consumer<Cluster.Builder>... clusters) {
            clusters(Stream.of(clusters).map(c -> Cluster.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClusters(Collection<Cluster.BuilderImpl> clusters) {
            this.clusters = ClustersCopier.copyFromBuilder(clusters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeClustersResponse build() {
            return new DescribeClustersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
