/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteHsmRequest extends CloudHsmV2Request implements
        ToCopyableBuilder<DeleteHsmRequest.Builder, DeleteHsmRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(DeleteHsmRequest::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<String> HSM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("HsmId")
            .getter(getter(DeleteHsmRequest::hsmId)).setter(setter(Builder::hsmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmId").build()).build();

    private static final SdkField<String> ENI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("EniId")
            .getter(getter(DeleteHsmRequest::eniId)).setter(setter(Builder::eniId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniId").build()).build();

    private static final SdkField<String> ENI_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("EniIp")
            .getter(getter(DeleteHsmRequest::eniIp)).setter(setter(Builder::eniIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD,
            HSM_ID_FIELD, ENI_ID_FIELD, ENI_IP_FIELD));

    private final String clusterId;

    private final String hsmId;

    private final String eniId;

    private final String eniIp;

    private DeleteHsmRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.hsmId = builder.hsmId;
        this.eniId = builder.eniId;
        this.eniIp = builder.eniIp;
    }

    /**
     * <p>
     * The identifier (ID) of the cluster that contains the HSM that you are deleting.
     * </p>
     * 
     * @return The identifier (ID) of the cluster that contains the HSM that you are deleting.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The identifier (ID) of the HSM that you are deleting.
     * </p>
     * 
     * @return The identifier (ID) of the HSM that you are deleting.
     */
    public final String hsmId() {
        return hsmId;
    }

    /**
     * <p>
     * The identifier (ID) of the elastic network interface (ENI) of the HSM that you are deleting.
     * </p>
     * 
     * @return The identifier (ID) of the elastic network interface (ENI) of the HSM that you are deleting.
     */
    public final String eniId() {
        return eniId;
    }

    /**
     * <p>
     * The IP address of the elastic network interface (ENI) of the HSM that you are deleting.
     * </p>
     * 
     * @return The IP address of the elastic network interface (ENI) of the HSM that you are deleting.
     */
    public final String eniIp() {
        return eniIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(hsmId());
        hashCode = 31 * hashCode + Objects.hashCode(eniId());
        hashCode = 31 * hashCode + Objects.hashCode(eniIp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteHsmRequest)) {
            return false;
        }
        DeleteHsmRequest other = (DeleteHsmRequest) obj;
        return Objects.equals(clusterId(), other.clusterId()) && Objects.equals(hsmId(), other.hsmId())
                && Objects.equals(eniId(), other.eniId()) && Objects.equals(eniIp(), other.eniIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteHsmRequest").add("ClusterId", clusterId()).add("HsmId", hsmId()).add("EniId", eniId())
                .add("EniIp", eniIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "HsmId":
            return Optional.ofNullable(clazz.cast(hsmId()));
        case "EniId":
            return Optional.ofNullable(clazz.cast(eniId()));
        case "EniIp":
            return Optional.ofNullable(clazz.cast(eniIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteHsmRequest, T> g) {
        return obj -> g.apply((DeleteHsmRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmV2Request.Builder, SdkPojo, CopyableBuilder<Builder, DeleteHsmRequest> {
        /**
         * <p>
         * The identifier (ID) of the cluster that contains the HSM that you are deleting.
         * </p>
         * 
         * @param clusterId
         *        The identifier (ID) of the cluster that contains the HSM that you are deleting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The identifier (ID) of the HSM that you are deleting.
         * </p>
         * 
         * @param hsmId
         *        The identifier (ID) of the HSM that you are deleting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmId(String hsmId);

        /**
         * <p>
         * The identifier (ID) of the elastic network interface (ENI) of the HSM that you are deleting.
         * </p>
         * 
         * @param eniId
         *        The identifier (ID) of the elastic network interface (ENI) of the HSM that you are deleting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eniId(String eniId);

        /**
         * <p>
         * The IP address of the elastic network interface (ENI) of the HSM that you are deleting.
         * </p>
         * 
         * @param eniIp
         *        The IP address of the elastic network interface (ENI) of the HSM that you are deleting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eniIp(String eniIp);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudHsmV2Request.BuilderImpl implements Builder {
        private String clusterId;

        private String hsmId;

        private String eniId;

        private String eniIp;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteHsmRequest model) {
            super(model);
            clusterId(model.clusterId);
            hsmId(model.hsmId);
            eniId(model.eniId);
            eniIp(model.eniIp);
        }

        public final String getClusterId() {
            return clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getHsmId() {
            return hsmId;
        }

        @Override
        public final Builder hsmId(String hsmId) {
            this.hsmId = hsmId;
            return this;
        }

        public final void setHsmId(String hsmId) {
            this.hsmId = hsmId;
        }

        public final String getEniId() {
            return eniId;
        }

        @Override
        public final Builder eniId(String eniId) {
            this.eniId = eniId;
            return this;
        }

        public final void setEniId(String eniId) {
            this.eniId = eniId;
        }

        public final String getEniIp() {
            return eniIp;
        }

        @Override
        public final Builder eniIp(String eniIp) {
            this.eniIp = eniIp;
            return this;
        }

        public final void setEniIp(String eniIp) {
            this.eniIp = eniIp;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteHsmRequest build() {
            return new DeleteHsmRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
