/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmV2Response;
import software.amazon.awssdk.services.cloudhsmv2.model.Hsm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateHsmResponse
extends CloudHsmV2Response
implements ToCopyableBuilder<Builder, CreateHsmResponse> {
    private static final SdkField<Hsm> HSM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Hsm").getter(CreateHsmResponse.getter(CreateHsmResponse::hsm)).setter(CreateHsmResponse.setter(Builder::hsm)).constructor(Hsm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hsm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HSM_FIELD));
    private final Hsm hsm;

    private CreateHsmResponse(BuilderImpl builder) {
        super(builder);
        this.hsm = builder.hsm;
    }

    public Hsm hsm() {
        return this.hsm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hsm());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHsmResponse)) {
            return false;
        }
        CreateHsmResponse other = (CreateHsmResponse)((Object)obj);
        return Objects.equals(this.hsm(), other.hsm());
    }

    public String toString() {
        return ToString.builder((String)"CreateHsmResponse").add("Hsm", (Object)this.hsm()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Hsm": {
                return Optional.ofNullable(clazz.cast(this.hsm()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHsmResponse, T> g) {
        return obj -> g.apply((CreateHsmResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmV2Response.BuilderImpl
    implements Builder {
        private Hsm hsm;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHsmResponse model) {
            super(model);
            this.hsm(model.hsm);
        }

        public final Hsm.Builder getHsm() {
            return this.hsm != null ? this.hsm.toBuilder() : null;
        }

        @Override
        public final Builder hsm(Hsm hsm) {
            this.hsm = hsm;
            return this;
        }

        public final void setHsm(Hsm.BuilderImpl hsm) {
            this.hsm = hsm != null ? hsm.build() : null;
        }

        @Override
        public CreateHsmResponse build() {
            return new CreateHsmResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudHsmV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateHsmResponse> {
        public Builder hsm(Hsm var1);

        default public Builder hsm(Consumer<Hsm.Builder> hsm) {
            return this.hsm((Hsm)((Hsm.Builder)Hsm.builder().applyMutation(hsm)).build());
        }
    }
}

