/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudhsmv2.model.BackupPolicy;
import software.amazon.awssdk.services.cloudhsmv2.model.BackupRetentionPolicy;
import software.amazon.awssdk.services.cloudhsmv2.model.Certificates;
import software.amazon.awssdk.services.cloudhsmv2.model.ClusterState;
import software.amazon.awssdk.services.cloudhsmv2.model.ExternalSubnetMappingCopier;
import software.amazon.awssdk.services.cloudhsmv2.model.Hsm;
import software.amazon.awssdk.services.cloudhsmv2.model.HsmsCopier;
import software.amazon.awssdk.services.cloudhsmv2.model.Tag;
import software.amazon.awssdk.services.cloudhsmv2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cluster> {
    private static final SdkField<String> BACKUP_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupPolicy").getter(Cluster.getter(Cluster::backupPolicyAsString)).setter(Cluster.setter(Builder::backupPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPolicy").build()}).build();
    private static final SdkField<BackupRetentionPolicy> BACKUP_RETENTION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BackupRetentionPolicy").getter(Cluster.getter(Cluster::backupRetentionPolicy)).setter(Cluster.setter(Builder::backupRetentionPolicy)).constructor(BackupRetentionPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPolicy").build()}).build();
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(Cluster.getter(Cluster::clusterId)).setter(Cluster.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<Instant> CREATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTimestamp").getter(Cluster.getter(Cluster::createTimestamp)).setter(Cluster.setter(Builder::createTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTimestamp").build()}).build();
    private static final SdkField<List<Hsm>> HSMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Hsms").getter(Cluster.getter(Cluster::hsms)).setter(Cluster.setter(Builder::hsms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hsms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Hsm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HSM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsmType").getter(Cluster.getter(Cluster::hsmType)).setter(Cluster.setter(Builder::hsmType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmType").build()}).build();
    private static final SdkField<String> PRE_CO_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreCoPassword").getter(Cluster.getter(Cluster::preCoPassword)).setter(Cluster.setter(Builder::preCoPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreCoPassword").build()}).build();
    private static final SdkField<String> SECURITY_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityGroup").getter(Cluster.getter(Cluster::securityGroup)).setter(Cluster.setter(Builder::securityGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroup").build()}).build();
    private static final SdkField<String> SOURCE_BACKUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceBackupId").getter(Cluster.getter(Cluster::sourceBackupId)).setter(Cluster.setter(Builder::sourceBackupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBackupId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Cluster.getter(Cluster::stateAsString)).setter(Cluster.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateMessage").getter(Cluster.getter(Cluster::stateMessage)).setter(Cluster.setter(Builder::stateMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateMessage").build()}).build();
    private static final SdkField<Map<String, String>> SUBNET_MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SubnetMapping").getter(Cluster.getter(Cluster::subnetMapping)).setter(Cluster.setter(Builder::subnetMapping)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetMapping").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(Cluster.getter(Cluster::vpcId)).setter(Cluster.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<Certificates> CERTIFICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Certificates").getter(Cluster.getter(Cluster::certificates)).setter(Cluster.setter(Builder::certificates)).constructor(Certificates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificates").build()}).build();
    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagList").getter(Cluster.getter(Cluster::tagList)).setter(Cluster.setter(Builder::tagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_POLICY_FIELD, BACKUP_RETENTION_POLICY_FIELD, CLUSTER_ID_FIELD, CREATE_TIMESTAMP_FIELD, HSMS_FIELD, HSM_TYPE_FIELD, PRE_CO_PASSWORD_FIELD, SECURITY_GROUP_FIELD, SOURCE_BACKUP_ID_FIELD, STATE_FIELD, STATE_MESSAGE_FIELD, SUBNET_MAPPING_FIELD, VPC_ID_FIELD, CERTIFICATES_FIELD, TAG_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String backupPolicy;
    private final BackupRetentionPolicy backupRetentionPolicy;
    private final String clusterId;
    private final Instant createTimestamp;
    private final List<Hsm> hsms;
    private final String hsmType;
    private final String preCoPassword;
    private final String securityGroup;
    private final String sourceBackupId;
    private final String state;
    private final String stateMessage;
    private final Map<String, String> subnetMapping;
    private final String vpcId;
    private final Certificates certificates;
    private final List<Tag> tagList;

    private Cluster(BuilderImpl builder) {
        this.backupPolicy = builder.backupPolicy;
        this.backupRetentionPolicy = builder.backupRetentionPolicy;
        this.clusterId = builder.clusterId;
        this.createTimestamp = builder.createTimestamp;
        this.hsms = builder.hsms;
        this.hsmType = builder.hsmType;
        this.preCoPassword = builder.preCoPassword;
        this.securityGroup = builder.securityGroup;
        this.sourceBackupId = builder.sourceBackupId;
        this.state = builder.state;
        this.stateMessage = builder.stateMessage;
        this.subnetMapping = builder.subnetMapping;
        this.vpcId = builder.vpcId;
        this.certificates = builder.certificates;
        this.tagList = builder.tagList;
    }

    public BackupPolicy backupPolicy() {
        return BackupPolicy.fromValue(this.backupPolicy);
    }

    public String backupPolicyAsString() {
        return this.backupPolicy;
    }

    public BackupRetentionPolicy backupRetentionPolicy() {
        return this.backupRetentionPolicy;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public Instant createTimestamp() {
        return this.createTimestamp;
    }

    public boolean hasHsms() {
        return this.hsms != null && !(this.hsms instanceof SdkAutoConstructList);
    }

    public List<Hsm> hsms() {
        return this.hsms;
    }

    public String hsmType() {
        return this.hsmType;
    }

    public String preCoPassword() {
        return this.preCoPassword;
    }

    public String securityGroup() {
        return this.securityGroup;
    }

    public String sourceBackupId() {
        return this.sourceBackupId;
    }

    public ClusterState state() {
        return ClusterState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String stateMessage() {
        return this.stateMessage;
    }

    public boolean hasSubnetMapping() {
        return this.subnetMapping != null && !(this.subnetMapping instanceof SdkAutoConstructMap);
    }

    public Map<String, String> subnetMapping() {
        return this.subnetMapping;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Certificates certificates() {
        return this.certificates;
    }

    public boolean hasTagList() {
        return this.tagList != null && !(this.tagList instanceof SdkAutoConstructList);
    }

    public List<Tag> tagList() {
        return this.tagList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHsms() ? this.hsms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmType());
        hashCode = 31 * hashCode + Objects.hashCode(this.preCoPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBackupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetMapping() ? this.subnetMapping() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificates());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagList() ? this.tagList() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return Objects.equals(this.backupPolicyAsString(), other.backupPolicyAsString()) && Objects.equals(this.backupRetentionPolicy(), other.backupRetentionPolicy()) && Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.createTimestamp(), other.createTimestamp()) && this.hasHsms() == other.hasHsms() && Objects.equals(this.hsms(), other.hsms()) && Objects.equals(this.hsmType(), other.hsmType()) && Objects.equals(this.preCoPassword(), other.preCoPassword()) && Objects.equals(this.securityGroup(), other.securityGroup()) && Objects.equals(this.sourceBackupId(), other.sourceBackupId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateMessage(), other.stateMessage()) && this.hasSubnetMapping() == other.hasSubnetMapping() && Objects.equals(this.subnetMapping(), other.subnetMapping()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.certificates(), other.certificates()) && this.hasTagList() == other.hasTagList() && Objects.equals(this.tagList(), other.tagList());
    }

    public String toString() {
        return ToString.builder((String)"Cluster").add("BackupPolicy", (Object)this.backupPolicyAsString()).add("BackupRetentionPolicy", (Object)this.backupRetentionPolicy()).add("ClusterId", (Object)this.clusterId()).add("CreateTimestamp", (Object)this.createTimestamp()).add("Hsms", this.hasHsms() ? this.hsms() : null).add("HsmType", (Object)this.hsmType()).add("PreCoPassword", (Object)this.preCoPassword()).add("SecurityGroup", (Object)this.securityGroup()).add("SourceBackupId", (Object)this.sourceBackupId()).add("State", (Object)this.stateAsString()).add("StateMessage", (Object)this.stateMessage()).add("SubnetMapping", this.hasSubnetMapping() ? this.subnetMapping() : null).add("VpcId", (Object)this.vpcId()).add("Certificates", (Object)this.certificates()).add("TagList", this.hasTagList() ? this.tagList() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupPolicy": {
                return Optional.ofNullable(clazz.cast(this.backupPolicyAsString()));
            }
            case "BackupRetentionPolicy": {
                return Optional.ofNullable(clazz.cast(this.backupRetentionPolicy()));
            }
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "CreateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createTimestamp()));
            }
            case "Hsms": {
                return Optional.ofNullable(clazz.cast(this.hsms()));
            }
            case "HsmType": {
                return Optional.ofNullable(clazz.cast(this.hsmType()));
            }
            case "PreCoPassword": {
                return Optional.ofNullable(clazz.cast(this.preCoPassword()));
            }
            case "SecurityGroup": {
                return Optional.ofNullable(clazz.cast(this.securityGroup()));
            }
            case "SourceBackupId": {
                return Optional.ofNullable(clazz.cast(this.sourceBackupId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateMessage": {
                return Optional.ofNullable(clazz.cast(this.stateMessage()));
            }
            case "SubnetMapping": {
                return Optional.ofNullable(clazz.cast(this.subnetMapping()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "Certificates": {
                return Optional.ofNullable(clazz.cast(this.certificates()));
            }
            case "TagList": {
                return Optional.ofNullable(clazz.cast(this.tagList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cluster, T> g) {
        return obj -> g.apply((Cluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String backupPolicy;
        private BackupRetentionPolicy backupRetentionPolicy;
        private String clusterId;
        private Instant createTimestamp;
        private List<Hsm> hsms = DefaultSdkAutoConstructList.getInstance();
        private String hsmType;
        private String preCoPassword;
        private String securityGroup;
        private String sourceBackupId;
        private String state;
        private String stateMessage;
        private Map<String, String> subnetMapping = DefaultSdkAutoConstructMap.getInstance();
        private String vpcId;
        private Certificates certificates;
        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            this.backupPolicy(model.backupPolicy);
            this.backupRetentionPolicy(model.backupRetentionPolicy);
            this.clusterId(model.clusterId);
            this.createTimestamp(model.createTimestamp);
            this.hsms(model.hsms);
            this.hsmType(model.hsmType);
            this.preCoPassword(model.preCoPassword);
            this.securityGroup(model.securityGroup);
            this.sourceBackupId(model.sourceBackupId);
            this.state(model.state);
            this.stateMessage(model.stateMessage);
            this.subnetMapping(model.subnetMapping);
            this.vpcId(model.vpcId);
            this.certificates(model.certificates);
            this.tagList(model.tagList);
        }

        public final String getBackupPolicy() {
            return this.backupPolicy;
        }

        @Override
        public final Builder backupPolicy(String backupPolicy) {
            this.backupPolicy = backupPolicy;
            return this;
        }

        @Override
        public final Builder backupPolicy(BackupPolicy backupPolicy) {
            this.backupPolicy(backupPolicy == null ? null : backupPolicy.toString());
            return this;
        }

        public final void setBackupPolicy(String backupPolicy) {
            this.backupPolicy = backupPolicy;
        }

        public final BackupRetentionPolicy.Builder getBackupRetentionPolicy() {
            return this.backupRetentionPolicy != null ? this.backupRetentionPolicy.toBuilder() : null;
        }

        @Override
        public final Builder backupRetentionPolicy(BackupRetentionPolicy backupRetentionPolicy) {
            this.backupRetentionPolicy = backupRetentionPolicy;
            return this;
        }

        public final void setBackupRetentionPolicy(BackupRetentionPolicy.BuilderImpl backupRetentionPolicy) {
            this.backupRetentionPolicy = backupRetentionPolicy != null ? backupRetentionPolicy.build() : null;
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final Instant getCreateTimestamp() {
            return this.createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        public final Collection<Hsm.Builder> getHsms() {
            if (this.hsms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hsms != null ? (Collection)this.hsms.stream().map(Hsm::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hsms(Collection<Hsm> hsms) {
            this.hsms = HsmsCopier.copy(hsms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsms(Hsm ... hsms) {
            this.hsms(Arrays.asList(hsms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsms(Consumer<Hsm.Builder> ... hsms) {
            this.hsms(Stream.of(hsms).map(c -> (Hsm)((Hsm.Builder)Hsm.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHsms(Collection<Hsm.BuilderImpl> hsms) {
            this.hsms = HsmsCopier.copyFromBuilder(hsms);
        }

        public final String getHsmType() {
            return this.hsmType;
        }

        @Override
        public final Builder hsmType(String hsmType) {
            this.hsmType = hsmType;
            return this;
        }

        public final void setHsmType(String hsmType) {
            this.hsmType = hsmType;
        }

        public final String getPreCoPassword() {
            return this.preCoPassword;
        }

        @Override
        public final Builder preCoPassword(String preCoPassword) {
            this.preCoPassword = preCoPassword;
            return this;
        }

        public final void setPreCoPassword(String preCoPassword) {
            this.preCoPassword = preCoPassword;
        }

        public final String getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public final Builder securityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public final void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        public final String getSourceBackupId() {
            return this.sourceBackupId;
        }

        @Override
        public final Builder sourceBackupId(String sourceBackupId) {
            this.sourceBackupId = sourceBackupId;
            return this;
        }

        public final void setSourceBackupId(String sourceBackupId) {
            this.sourceBackupId = sourceBackupId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ClusterState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateMessage() {
            return this.stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        public final Map<String, String> getSubnetMapping() {
            if (this.subnetMapping instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.subnetMapping;
        }

        @Override
        public final Builder subnetMapping(Map<String, String> subnetMapping) {
            this.subnetMapping = ExternalSubnetMappingCopier.copy(subnetMapping);
            return this;
        }

        public final void setSubnetMapping(Map<String, String> subnetMapping) {
            this.subnetMapping = ExternalSubnetMappingCopier.copy(subnetMapping);
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Certificates.Builder getCertificates() {
            return this.certificates != null ? this.certificates.toBuilder() : null;
        }

        @Override
        public final Builder certificates(Certificates certificates) {
            this.certificates = certificates;
            return this;
        }

        public final void setCertificates(Certificates.BuilderImpl certificates) {
            this.certificates = certificates != null ? certificates.build() : null;
        }

        public final Collection<Tag.Builder> getTagList() {
            if (this.tagList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagList != null ? (Collection)this.tagList.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder> ... tagList) {
            this.tagList(Stream.of(tagList).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        public Cluster build() {
            return new Cluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cluster> {
        public Builder backupPolicy(String var1);

        public Builder backupPolicy(BackupPolicy var1);

        public Builder backupRetentionPolicy(BackupRetentionPolicy var1);

        default public Builder backupRetentionPolicy(Consumer<BackupRetentionPolicy.Builder> backupRetentionPolicy) {
            return this.backupRetentionPolicy((BackupRetentionPolicy)((BackupRetentionPolicy.Builder)BackupRetentionPolicy.builder().applyMutation(backupRetentionPolicy)).build());
        }

        public Builder clusterId(String var1);

        public Builder createTimestamp(Instant var1);

        public Builder hsms(Collection<Hsm> var1);

        public Builder hsms(Hsm ... var1);

        public Builder hsms(Consumer<Hsm.Builder> ... var1);

        public Builder hsmType(String var1);

        public Builder preCoPassword(String var1);

        public Builder securityGroup(String var1);

        public Builder sourceBackupId(String var1);

        public Builder state(String var1);

        public Builder state(ClusterState var1);

        public Builder stateMessage(String var1);

        public Builder subnetMapping(Map<String, String> var1);

        public Builder vpcId(String var1);

        public Builder certificates(Certificates var1);

        default public Builder certificates(Consumer<Certificates.Builder> certificates) {
            return this.certificates((Certificates)((Certificates.Builder)Certificates.builder().applyMutation(certificates)).build());
        }

        public Builder tagList(Collection<Tag> var1);

        public Builder tagList(Tag ... var1);

        public Builder tagList(Consumer<Tag.Builder> ... var1);
    }
}

