/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsmv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an AWS CloudHSM cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Cluster implements SdkPojo, Serializable, ToCopyableBuilder<Cluster.Builder, Cluster> {
    private static final SdkField<String> BACKUP_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::backupPolicyAsString)).setter(setter(Builder::backupPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPolicy").build()).build();

    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<Instant> CREATE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Cluster::createTimestamp)).setter(setter(Builder::createTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTimestamp").build()).build();

    private static final SdkField<List<Hsm>> HSMS_FIELD = SdkField
            .<List<Hsm>> builder(MarshallingType.LIST)
            .getter(getter(Cluster::hsms))
            .setter(setter(Builder::hsms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hsms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Hsm> builder(MarshallingType.SDK_POJO)
                                            .constructor(Hsm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> HSM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::hsmType)).setter(setter(Builder::hsmType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmType").build()).build();

    private static final SdkField<String> PRE_CO_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::preCoPassword)).setter(setter(Builder::preCoPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreCoPassword").build()).build();

    private static final SdkField<String> SECURITY_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::securityGroup)).setter(setter(Builder::securityGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroup").build()).build();

    private static final SdkField<String> SOURCE_BACKUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::sourceBackupId)).setter(setter(Builder::sourceBackupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBackupId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::stateMessage)).setter(setter(Builder::stateMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateMessage").build()).build();

    private static final SdkField<Map<String, String>> SUBNET_MAPPING_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(Cluster::subnetMapping))
            .setter(setter(Builder::subnetMapping))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetMapping").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<Certificates> CERTIFICATES_FIELD = SdkField.<Certificates> builder(MarshallingType.SDK_POJO)
            .getter(getter(Cluster::certificates)).setter(setter(Builder::certificates)).constructor(Certificates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificates").build()).build();

    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(Cluster::tagList))
            .setter(setter(Builder::tagList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_POLICY_FIELD,
            CLUSTER_ID_FIELD, CREATE_TIMESTAMP_FIELD, HSMS_FIELD, HSM_TYPE_FIELD, PRE_CO_PASSWORD_FIELD, SECURITY_GROUP_FIELD,
            SOURCE_BACKUP_ID_FIELD, STATE_FIELD, STATE_MESSAGE_FIELD, SUBNET_MAPPING_FIELD, VPC_ID_FIELD, CERTIFICATES_FIELD,
            TAG_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String backupPolicy;

    private final String clusterId;

    private final Instant createTimestamp;

    private final List<Hsm> hsms;

    private final String hsmType;

    private final String preCoPassword;

    private final String securityGroup;

    private final String sourceBackupId;

    private final String state;

    private final String stateMessage;

    private final Map<String, String> subnetMapping;

    private final String vpcId;

    private final Certificates certificates;

    private final List<Tag> tagList;

    private Cluster(BuilderImpl builder) {
        this.backupPolicy = builder.backupPolicy;
        this.clusterId = builder.clusterId;
        this.createTimestamp = builder.createTimestamp;
        this.hsms = builder.hsms;
        this.hsmType = builder.hsmType;
        this.preCoPassword = builder.preCoPassword;
        this.securityGroup = builder.securityGroup;
        this.sourceBackupId = builder.sourceBackupId;
        this.state = builder.state;
        this.stateMessage = builder.stateMessage;
        this.subnetMapping = builder.subnetMapping;
        this.vpcId = builder.vpcId;
        this.certificates = builder.certificates;
        this.tagList = builder.tagList;
    }

    /**
     * <p>
     * The cluster's backup policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backupPolicy} will
     * return {@link BackupPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backupPolicyAsString}.
     * </p>
     * 
     * @return The cluster's backup policy.
     * @see BackupPolicy
     */
    public BackupPolicy backupPolicy() {
        return BackupPolicy.fromValue(backupPolicy);
    }

    /**
     * <p>
     * The cluster's backup policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backupPolicy} will
     * return {@link BackupPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backupPolicyAsString}.
     * </p>
     * 
     * @return The cluster's backup policy.
     * @see BackupPolicy
     */
    public String backupPolicyAsString() {
        return backupPolicy;
    }

    /**
     * <p>
     * The cluster's identifier (ID).
     * </p>
     * 
     * @return The cluster's identifier (ID).
     */
    public String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The date and time when the cluster was created.
     * </p>
     * 
     * @return The date and time when the cluster was created.
     */
    public Instant createTimestamp() {
        return createTimestamp;
    }

    /**
     * Returns true if the Hsms property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasHsms() {
        return hsms != null && !(hsms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about the HSMs in the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHsms()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains information about the HSMs in the cluster.
     */
    public List<Hsm> hsms() {
        return hsms;
    }

    /**
     * <p>
     * The type of HSM that the cluster contains.
     * </p>
     * 
     * @return The type of HSM that the cluster contains.
     */
    public String hsmType() {
        return hsmType;
    }

    /**
     * <p>
     * The default password for the cluster's Pre-Crypto Officer (PRECO) user.
     * </p>
     * 
     * @return The default password for the cluster's Pre-Crypto Officer (PRECO) user.
     */
    public String preCoPassword() {
        return preCoPassword;
    }

    /**
     * <p>
     * The identifier (ID) of the cluster's security group.
     * </p>
     * 
     * @return The identifier (ID) of the cluster's security group.
     */
    public String securityGroup() {
        return securityGroup;
    }

    /**
     * <p>
     * The identifier (ID) of the backup used to create the cluster. This value exists only when the cluster was created
     * from a backup.
     * </p>
     * 
     * @return The identifier (ID) of the backup used to create the cluster. This value exists only when the cluster was
     *         created from a backup.
     */
    public String sourceBackupId() {
        return sourceBackupId;
    }

    /**
     * <p>
     * The cluster's state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ClusterState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The cluster's state.
     * @see ClusterState
     */
    public ClusterState state() {
        return ClusterState.fromValue(state);
    }

    /**
     * <p>
     * The cluster's state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ClusterState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The cluster's state.
     * @see ClusterState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * A description of the cluster's state.
     * </p>
     * 
     * @return A description of the cluster's state.
     */
    public String stateMessage() {
        return stateMessage;
    }

    /**
     * Returns true if the SubnetMapping property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubnetMapping() {
        return subnetMapping != null && !(subnetMapping instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map from availability zone to the cluster’s subnet in that availability zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetMapping()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map from availability zone to the cluster’s subnet in that availability zone.
     */
    public Map<String, String> subnetMapping() {
        return subnetMapping;
    }

    /**
     * <p>
     * The identifier (ID) of the virtual private cloud (VPC) that contains the cluster.
     * </p>
     * 
     * @return The identifier (ID) of the virtual private cloud (VPC) that contains the cluster.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * Contains one or more certificates or a certificate signing request (CSR).
     * </p>
     * 
     * @return Contains one or more certificates or a certificate signing request (CSR).
     */
    public Certificates certificates() {
        return certificates;
    }

    /**
     * Returns true if the TagList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTagList() {
        return tagList != null && !(tagList instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the TagList property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the TagList property for this object.
     */
    public List<Tag> tagList() {
        return tagList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(createTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hsms());
        hashCode = 31 * hashCode + Objects.hashCode(hsmType());
        hashCode = 31 * hashCode + Objects.hashCode(preCoPassword());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBackupId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateMessage());
        hashCode = 31 * hashCode + Objects.hashCode(subnetMapping());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(certificates());
        hashCode = 31 * hashCode + Objects.hashCode(tagList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster) obj;
        return Objects.equals(backupPolicyAsString(), other.backupPolicyAsString())
                && Objects.equals(clusterId(), other.clusterId()) && Objects.equals(createTimestamp(), other.createTimestamp())
                && Objects.equals(hsms(), other.hsms()) && Objects.equals(hsmType(), other.hsmType())
                && Objects.equals(preCoPassword(), other.preCoPassword())
                && Objects.equals(securityGroup(), other.securityGroup())
                && Objects.equals(sourceBackupId(), other.sourceBackupId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(stateMessage(), other.stateMessage())
                && Objects.equals(subnetMapping(), other.subnetMapping()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(certificates(), other.certificates()) && Objects.equals(tagList(), other.tagList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Cluster").add("BackupPolicy", backupPolicyAsString()).add("ClusterId", clusterId())
                .add("CreateTimestamp", createTimestamp()).add("Hsms", hsms()).add("HsmType", hsmType())
                .add("PreCoPassword", preCoPassword()).add("SecurityGroup", securityGroup())
                .add("SourceBackupId", sourceBackupId()).add("State", stateAsString()).add("StateMessage", stateMessage())
                .add("SubnetMapping", subnetMapping()).add("VpcId", vpcId()).add("Certificates", certificates())
                .add("TagList", tagList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPolicy":
            return Optional.ofNullable(clazz.cast(backupPolicyAsString()));
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "CreateTimestamp":
            return Optional.ofNullable(clazz.cast(createTimestamp()));
        case "Hsms":
            return Optional.ofNullable(clazz.cast(hsms()));
        case "HsmType":
            return Optional.ofNullable(clazz.cast(hsmType()));
        case "PreCoPassword":
            return Optional.ofNullable(clazz.cast(preCoPassword()));
        case "SecurityGroup":
            return Optional.ofNullable(clazz.cast(securityGroup()));
        case "SourceBackupId":
            return Optional.ofNullable(clazz.cast(sourceBackupId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateMessage":
            return Optional.ofNullable(clazz.cast(stateMessage()));
        case "SubnetMapping":
            return Optional.ofNullable(clazz.cast(subnetMapping()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "Certificates":
            return Optional.ofNullable(clazz.cast(certificates()));
        case "TagList":
            return Optional.ofNullable(clazz.cast(tagList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cluster, T> g) {
        return obj -> g.apply((Cluster) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Cluster> {
        /**
         * <p>
         * The cluster's backup policy.
         * </p>
         * 
         * @param backupPolicy
         *        The cluster's backup policy.
         * @see BackupPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupPolicy
         */
        Builder backupPolicy(String backupPolicy);

        /**
         * <p>
         * The cluster's backup policy.
         * </p>
         * 
         * @param backupPolicy
         *        The cluster's backup policy.
         * @see BackupPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupPolicy
         */
        Builder backupPolicy(BackupPolicy backupPolicy);

        /**
         * <p>
         * The cluster's identifier (ID).
         * </p>
         * 
         * @param clusterId
         *        The cluster's identifier (ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The date and time when the cluster was created.
         * </p>
         * 
         * @param createTimestamp
         *        The date and time when the cluster was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTimestamp(Instant createTimestamp);

        /**
         * <p>
         * Contains information about the HSMs in the cluster.
         * </p>
         * 
         * @param hsms
         *        Contains information about the HSMs in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsms(Collection<Hsm> hsms);

        /**
         * <p>
         * Contains information about the HSMs in the cluster.
         * </p>
         * 
         * @param hsms
         *        Contains information about the HSMs in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsms(Hsm... hsms);

        /**
         * <p>
         * Contains information about the HSMs in the cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Hsm>.Builder} avoiding the need to create
         * one manually via {@link List<Hsm>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Hsm>.Builder#build()} is called immediately and its result
         * is passed to {@link #hsms(List<Hsm>)}.
         * 
         * @param hsms
         *        a consumer that will call methods on {@link List<Hsm>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hsms(List<Hsm>)
         */
        Builder hsms(Consumer<Hsm.Builder>... hsms);

        /**
         * <p>
         * The type of HSM that the cluster contains.
         * </p>
         * 
         * @param hsmType
         *        The type of HSM that the cluster contains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmType(String hsmType);

        /**
         * <p>
         * The default password for the cluster's Pre-Crypto Officer (PRECO) user.
         * </p>
         * 
         * @param preCoPassword
         *        The default password for the cluster's Pre-Crypto Officer (PRECO) user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preCoPassword(String preCoPassword);

        /**
         * <p>
         * The identifier (ID) of the cluster's security group.
         * </p>
         * 
         * @param securityGroup
         *        The identifier (ID) of the cluster's security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroup(String securityGroup);

        /**
         * <p>
         * The identifier (ID) of the backup used to create the cluster. This value exists only when the cluster was
         * created from a backup.
         * </p>
         * 
         * @param sourceBackupId
         *        The identifier (ID) of the backup used to create the cluster. This value exists only when the cluster
         *        was created from a backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBackupId(String sourceBackupId);

        /**
         * <p>
         * The cluster's state.
         * </p>
         * 
         * @param state
         *        The cluster's state.
         * @see ClusterState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterState
         */
        Builder state(String state);

        /**
         * <p>
         * The cluster's state.
         * </p>
         * 
         * @param state
         *        The cluster's state.
         * @see ClusterState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterState
         */
        Builder state(ClusterState state);

        /**
         * <p>
         * A description of the cluster's state.
         * </p>
         * 
         * @param stateMessage
         *        A description of the cluster's state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMessage(String stateMessage);

        /**
         * <p>
         * A map from availability zone to the cluster’s subnet in that availability zone.
         * </p>
         * 
         * @param subnetMapping
         *        A map from availability zone to the cluster’s subnet in that availability zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetMapping(Map<String, String> subnetMapping);

        /**
         * <p>
         * The identifier (ID) of the virtual private cloud (VPC) that contains the cluster.
         * </p>
         * 
         * @param vpcId
         *        The identifier (ID) of the virtual private cloud (VPC) that contains the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Contains one or more certificates or a certificate signing request (CSR).
         * </p>
         * 
         * @param certificates
         *        Contains one or more certificates or a certificate signing request (CSR).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(Certificates certificates);

        /**
         * <p>
         * Contains one or more certificates or a certificate signing request (CSR).
         * </p>
         * This is a convenience that creates an instance of the {@link Certificates.Builder} avoiding the need to
         * create one manually via {@link Certificates#builder()}.
         *
         * When the {@link Consumer} completes, {@link Certificates.Builder#build()} is called immediately and its
         * result is passed to {@link #certificates(Certificates)}.
         * 
         * @param certificates
         *        a consumer that will call methods on {@link Certificates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificates(Certificates)
         */
        default Builder certificates(Consumer<Certificates.Builder> certificates) {
            return certificates(Certificates.builder().applyMutation(certificates).build());
        }

        /**
         * Sets the value of the TagList property for this object.
         *
         * @param tagList
         *        The new value for the TagList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Collection<Tag> tagList);

        /**
         * Sets the value of the TagList property for this object.
         *
         * @param tagList
         *        The new value for the TagList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Tag... tagList);

        /**
         * Sets the value of the TagList property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tagList(List<Tag>)}.
         * 
         * @param tagList
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagList(List<Tag>)
         */
        Builder tagList(Consumer<Tag.Builder>... tagList);
    }

    static final class BuilderImpl implements Builder {
        private String backupPolicy;

        private String clusterId;

        private Instant createTimestamp;

        private List<Hsm> hsms = DefaultSdkAutoConstructList.getInstance();

        private String hsmType;

        private String preCoPassword;

        private String securityGroup;

        private String sourceBackupId;

        private String state;

        private String stateMessage;

        private Map<String, String> subnetMapping = DefaultSdkAutoConstructMap.getInstance();

        private String vpcId;

        private Certificates certificates;

        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            backupPolicy(model.backupPolicy);
            clusterId(model.clusterId);
            createTimestamp(model.createTimestamp);
            hsms(model.hsms);
            hsmType(model.hsmType);
            preCoPassword(model.preCoPassword);
            securityGroup(model.securityGroup);
            sourceBackupId(model.sourceBackupId);
            state(model.state);
            stateMessage(model.stateMessage);
            subnetMapping(model.subnetMapping);
            vpcId(model.vpcId);
            certificates(model.certificates);
            tagList(model.tagList);
        }

        public final String getBackupPolicy() {
            return backupPolicy;
        }

        @Override
        public final Builder backupPolicy(String backupPolicy) {
            this.backupPolicy = backupPolicy;
            return this;
        }

        @Override
        public final Builder backupPolicy(BackupPolicy backupPolicy) {
            this.backupPolicy(backupPolicy == null ? null : backupPolicy.toString());
            return this;
        }

        public final void setBackupPolicy(String backupPolicy) {
            this.backupPolicy = backupPolicy;
        }

        public final String getClusterId() {
            return clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final Instant getCreateTimestamp() {
            return createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        public final Collection<Hsm.Builder> getHsms() {
            return hsms != null ? hsms.stream().map(Hsm::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hsms(Collection<Hsm> hsms) {
            this.hsms = HsmsCopier.copy(hsms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsms(Hsm... hsms) {
            hsms(Arrays.asList(hsms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsms(Consumer<Hsm.Builder>... hsms) {
            hsms(Stream.of(hsms).map(c -> Hsm.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHsms(Collection<Hsm.BuilderImpl> hsms) {
            this.hsms = HsmsCopier.copyFromBuilder(hsms);
        }

        public final String getHsmType() {
            return hsmType;
        }

        @Override
        public final Builder hsmType(String hsmType) {
            this.hsmType = hsmType;
            return this;
        }

        public final void setHsmType(String hsmType) {
            this.hsmType = hsmType;
        }

        public final String getPreCoPassword() {
            return preCoPassword;
        }

        @Override
        public final Builder preCoPassword(String preCoPassword) {
            this.preCoPassword = preCoPassword;
            return this;
        }

        public final void setPreCoPassword(String preCoPassword) {
            this.preCoPassword = preCoPassword;
        }

        public final String getSecurityGroup() {
            return securityGroup;
        }

        @Override
        public final Builder securityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public final void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        public final String getSourceBackupId() {
            return sourceBackupId;
        }

        @Override
        public final Builder sourceBackupId(String sourceBackupId) {
            this.sourceBackupId = sourceBackupId;
            return this;
        }

        public final void setSourceBackupId(String sourceBackupId) {
            this.sourceBackupId = sourceBackupId;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ClusterState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateMessage() {
            return stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        public final Map<String, String> getSubnetMapping() {
            return subnetMapping;
        }

        @Override
        public final Builder subnetMapping(Map<String, String> subnetMapping) {
            this.subnetMapping = ExternalSubnetMappingCopier.copy(subnetMapping);
            return this;
        }

        public final void setSubnetMapping(Map<String, String> subnetMapping) {
            this.subnetMapping = ExternalSubnetMappingCopier.copy(subnetMapping);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Certificates.Builder getCertificates() {
            return certificates != null ? certificates.toBuilder() : null;
        }

        @Override
        public final Builder certificates(Certificates certificates) {
            this.certificates = certificates;
            return this;
        }

        public final void setCertificates(Certificates.BuilderImpl certificates) {
            this.certificates = certificates != null ? certificates.build() : null;
        }

        public final Collection<Tag.Builder> getTagList() {
            return tagList != null ? tagList.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag... tagList) {
            tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder>... tagList) {
            tagList(Stream.of(tagList).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public Cluster build() {
            return new Cluster(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
