/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConfigResponse
extends CloudHsmResponse
implements ToCopyableBuilder<Builder, GetConfigResponse> {
    private static final SdkField<String> CONFIG_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetConfigResponse.getter(GetConfigResponse::configType)).setter(GetConfigResponse.setter(Builder::configType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigType").build()}).build();
    private static final SdkField<String> CONFIG_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetConfigResponse.getter(GetConfigResponse::configFile)).setter(GetConfigResponse.setter(Builder::configFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigFile").build()}).build();
    private static final SdkField<String> CONFIG_CRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetConfigResponse.getter(GetConfigResponse::configCred)).setter(GetConfigResponse.setter(Builder::configCred)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigCred").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_TYPE_FIELD, CONFIG_FILE_FIELD, CONFIG_CRED_FIELD));
    private final String configType;
    private final String configFile;
    private final String configCred;

    private GetConfigResponse(BuilderImpl builder) {
        super(builder);
        this.configType = builder.configType;
        this.configFile = builder.configFile;
        this.configCred = builder.configCred;
    }

    public String configType() {
        return this.configType;
    }

    public String configFile() {
        return this.configFile;
    }

    public String configCred() {
        return this.configCred;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configType());
        hashCode = 31 * hashCode + Objects.hashCode(this.configFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.configCred());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigResponse)) {
            return false;
        }
        GetConfigResponse other = (GetConfigResponse)((Object)obj);
        return Objects.equals(this.configType(), other.configType()) && Objects.equals(this.configFile(), other.configFile()) && Objects.equals(this.configCred(), other.configCred());
    }

    public String toString() {
        return ToString.builder((String)"GetConfigResponse").add("ConfigType", (Object)this.configType()).add("ConfigFile", (Object)this.configFile()).add("ConfigCred", (Object)this.configCred()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigType": {
                return Optional.ofNullable(clazz.cast(this.configType()));
            }
            case "ConfigFile": {
                return Optional.ofNullable(clazz.cast(this.configFile()));
            }
            case "ConfigCred": {
                return Optional.ofNullable(clazz.cast(this.configCred()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConfigResponse, T> g) {
        return obj -> g.apply((GetConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmResponse.BuilderImpl
    implements Builder {
        private String configType;
        private String configFile;
        private String configCred;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigResponse model) {
            super(model);
            this.configType(model.configType);
            this.configFile(model.configFile);
            this.configCred(model.configCred);
        }

        public final String getConfigType() {
            return this.configType;
        }

        @Override
        public final Builder configType(String configType) {
            this.configType = configType;
            return this;
        }

        public final void setConfigType(String configType) {
            this.configType = configType;
        }

        public final String getConfigFile() {
            return this.configFile;
        }

        @Override
        public final Builder configFile(String configFile) {
            this.configFile = configFile;
            return this;
        }

        public final void setConfigFile(String configFile) {
            this.configFile = configFile;
        }

        public final String getConfigCred() {
            return this.configCred;
        }

        @Override
        public final Builder configCred(String configCred) {
            this.configCred = configCred;
            return this;
        }

        public final void setConfigCred(String configCred) {
            this.configCred = configCred;
        }

        @Override
        public GetConfigResponse build() {
            return new GetConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudHsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConfigResponse> {
        public Builder configType(String var1);

        public Builder configFile(String var1);

        public Builder configCred(String var1);
    }
}

