/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudhsm.model.AZListCopier;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAvailableZonesResponse
extends CloudHsmResponse
implements ToCopyableBuilder<Builder, ListAvailableZonesResponse> {
    private static final SdkField<List<String>> AZ_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AZList").getter(ListAvailableZonesResponse.getter(ListAvailableZonesResponse::azList)).setter(ListAvailableZonesResponse.setter(Builder::azList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AZList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AZ_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AZList", AZ_LIST_FIELD);
        }
    });
    private final List<String> azList;

    private ListAvailableZonesResponse(BuilderImpl builder) {
        super(builder);
        this.azList = builder.azList;
    }

    public final boolean hasAzList() {
        return this.azList != null && !(this.azList instanceof SdkAutoConstructList);
    }

    public final List<String> azList() {
        return this.azList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAzList() ? this.azList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAvailableZonesResponse)) {
            return false;
        }
        ListAvailableZonesResponse other = (ListAvailableZonesResponse)((Object)obj);
        return this.hasAzList() == other.hasAzList() && Objects.equals(this.azList(), other.azList());
    }

    public final String toString() {
        return ToString.builder((String)"ListAvailableZonesResponse").add("AZList", this.hasAzList() ? this.azList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AZList": {
                return Optional.ofNullable(clazz.cast(this.azList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAvailableZonesResponse, T> g) {
        return obj -> g.apply((ListAvailableZonesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmResponse.BuilderImpl
    implements Builder {
        private List<String> azList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAvailableZonesResponse model) {
            super(model);
            this.azList(model.azList);
        }

        public final Collection<String> getAzList() {
            if (this.azList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.azList;
        }

        public final void setAzList(Collection<String> azList) {
            this.azList = AZListCopier.copy(azList);
        }

        @Override
        public final Builder azList(Collection<String> azList) {
            this.azList = AZListCopier.copy(azList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder azList(String ... azList) {
            this.azList(Arrays.asList(azList));
            return this;
        }

        @Override
        public ListAvailableZonesResponse build() {
            return new ListAvailableZonesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudHsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAvailableZonesResponse> {
        public Builder azList(Collection<String> var1);

        public Builder azList(String ... var1);
    }
}

