/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudhsm.CloudHsmClient;
import software.amazon.awssdk.services.cloudhsm.CloudHsmClientBuilder;
import software.amazon.awssdk.services.cloudhsm.CloudHsmServiceClientConfiguration;
import software.amazon.awssdk.services.cloudhsm.DefaultCloudHsmBaseClientBuilder;
import software.amazon.awssdk.services.cloudhsm.DefaultCloudHsmClient;
import software.amazon.awssdk.services.cloudhsm.endpoints.CloudHsmEndpointProvider;

@SdkInternalApi
final class DefaultCloudHsmClientBuilder
extends DefaultCloudHsmBaseClientBuilder<CloudHsmClientBuilder, CloudHsmClient>
implements CloudHsmClientBuilder {
    DefaultCloudHsmClientBuilder() {
    }

    @Override
    public DefaultCloudHsmClientBuilder endpointProvider(CloudHsmEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudHsmClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCloudHsmClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CloudHsmServiceClientConfiguration serviceClientConfiguration = CloudHsmServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCloudHsmClient(serviceClientConfiguration, clientConfiguration);
    }
}

