/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLunaClientResponse
extends CloudHsmResponse
implements ToCopyableBuilder<Builder, DescribeLunaClientResponse> {
    private static final SdkField<String> CLIENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientArn").getter(DescribeLunaClientResponse.getter(DescribeLunaClientResponse::clientArn)).setter(DescribeLunaClientResponse.setter(Builder::clientArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientArn").build()}).build();
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Certificate").getter(DescribeLunaClientResponse.getter(DescribeLunaClientResponse::certificate)).setter(DescribeLunaClientResponse.setter(Builder::certificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()}).build();
    private static final SdkField<String> CERTIFICATE_FINGERPRINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateFingerprint").getter(DescribeLunaClientResponse.getter(DescribeLunaClientResponse::certificateFingerprint)).setter(DescribeLunaClientResponse.setter(Builder::certificateFingerprint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateFingerprint").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedTimestamp").getter(DescribeLunaClientResponse.getter(DescribeLunaClientResponse::lastModifiedTimestamp)).setter(DescribeLunaClientResponse.setter(Builder::lastModifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimestamp").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Label").getter(DescribeLunaClientResponse.getter(DescribeLunaClientResponse::label)).setter(DescribeLunaClientResponse.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ARN_FIELD, CERTIFICATE_FIELD, CERTIFICATE_FINGERPRINT_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, LABEL_FIELD));
    private final String clientArn;
    private final String certificate;
    private final String certificateFingerprint;
    private final String lastModifiedTimestamp;
    private final String label;

    private DescribeLunaClientResponse(BuilderImpl builder) {
        super(builder);
        this.clientArn = builder.clientArn;
        this.certificate = builder.certificate;
        this.certificateFingerprint = builder.certificateFingerprint;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.label = builder.label;
    }

    public final String clientArn() {
        return this.clientArn;
    }

    public final String certificate() {
        return this.certificate;
    }

    public final String certificateFingerprint() {
        return this.certificateFingerprint;
    }

    public final String lastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public final String label() {
        return this.label;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateFingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLunaClientResponse)) {
            return false;
        }
        DescribeLunaClientResponse other = (DescribeLunaClientResponse)((Object)obj);
        return Objects.equals(this.clientArn(), other.clientArn()) && Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.certificateFingerprint(), other.certificateFingerprint()) && Objects.equals(this.lastModifiedTimestamp(), other.lastModifiedTimestamp()) && Objects.equals(this.label(), other.label());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLunaClientResponse").add("ClientArn", (Object)this.clientArn()).add("Certificate", (Object)this.certificate()).add("CertificateFingerprint", (Object)this.certificateFingerprint()).add("LastModifiedTimestamp", (Object)this.lastModifiedTimestamp()).add("Label", (Object)this.label()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientArn": {
                return Optional.ofNullable(clazz.cast(this.clientArn()));
            }
            case "Certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "CertificateFingerprint": {
                return Optional.ofNullable(clazz.cast(this.certificateFingerprint()));
            }
            case "LastModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimestamp()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLunaClientResponse, T> g) {
        return obj -> g.apply((DescribeLunaClientResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmResponse.BuilderImpl
    implements Builder {
        private String clientArn;
        private String certificate;
        private String certificateFingerprint;
        private String lastModifiedTimestamp;
        private String label;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLunaClientResponse model) {
            super(model);
            this.clientArn(model.clientArn);
            this.certificate(model.certificate);
            this.certificateFingerprint(model.certificateFingerprint);
            this.lastModifiedTimestamp(model.lastModifiedTimestamp);
            this.label(model.label);
        }

        public final String getClientArn() {
            return this.clientArn;
        }

        public final void setClientArn(String clientArn) {
            this.clientArn = clientArn;
        }

        @Override
        @Transient
        public final Builder clientArn(String clientArn) {
            this.clientArn = clientArn;
            return this;
        }

        public final String getCertificate() {
            return this.certificate;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        @Transient
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final String getCertificateFingerprint() {
            return this.certificateFingerprint;
        }

        public final void setCertificateFingerprint(String certificateFingerprint) {
            this.certificateFingerprint = certificateFingerprint;
        }

        @Override
        @Transient
        public final Builder certificateFingerprint(String certificateFingerprint) {
            this.certificateFingerprint = certificateFingerprint;
            return this;
        }

        public final String getLastModifiedTimestamp() {
            return this.lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(String lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        @Transient
        public final Builder lastModifiedTimestamp(String lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        @Transient
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        @Override
        public DescribeLunaClientResponse build() {
            return new DescribeLunaClientResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudHsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLunaClientResponse> {
        public Builder clientArn(String var1);

        public Builder certificate(String var1);

        public Builder certificateFingerprint(String var1);

        public Builder lastModifiedTimestamp(String var1);

        public Builder label(String var1);
    }
}

