/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the inputs for the <code>CreateHsm</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHsmRequest extends CloudHsmRequest implements
        ToCopyableBuilder<CreateHsmRequest.Builder, CreateHsmRequest> {
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(CreateHsmRequest::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> SSH_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SshKey")
            .getter(getter(CreateHsmRequest::sshKey)).setter(setter(Builder::sshKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshKey").build()).build();

    private static final SdkField<String> ENI_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("EniIp")
            .getter(getter(CreateHsmRequest::eniIp)).setter(setter(Builder::eniIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniIp").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(CreateHsmRequest::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalId").getter(getter(CreateHsmRequest::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalId").build()).build();

    private static final SdkField<String> SUBSCRIPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionType").getter(getter(CreateHsmRequest::subscriptionTypeAsString))
            .setter(setter(Builder::subscriptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionType").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(CreateHsmRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> SYSLOG_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SyslogIp").getter(getter(CreateHsmRequest::syslogIp)).setter(setter(Builder::syslogIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyslogIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_FIELD,
            SSH_KEY_FIELD, ENI_IP_FIELD, IAM_ROLE_ARN_FIELD, EXTERNAL_ID_FIELD, SUBSCRIPTION_TYPE_FIELD, CLIENT_TOKEN_FIELD,
            SYSLOG_IP_FIELD));

    private final String subnetId;

    private final String sshKey;

    private final String eniIp;

    private final String iamRoleArn;

    private final String externalId;

    private final String subscriptionType;

    private final String clientToken;

    private final String syslogIp;

    private CreateHsmRequest(BuilderImpl builder) {
        super(builder);
        this.subnetId = builder.subnetId;
        this.sshKey = builder.sshKey;
        this.eniIp = builder.eniIp;
        this.iamRoleArn = builder.iamRoleArn;
        this.externalId = builder.externalId;
        this.subscriptionType = builder.subscriptionType;
        this.clientToken = builder.clientToken;
        this.syslogIp = builder.syslogIp;
    }

    /**
     * <p>
     * The identifier of the subnet in your VPC in which to place the HSM.
     * </p>
     * 
     * @return The identifier of the subnet in your VPC in which to place the HSM.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The SSH public key to install on the HSM.
     * </p>
     * 
     * @return The SSH public key to install on the HSM.
     */
    public final String sshKey() {
        return sshKey;
    }

    /**
     * <p>
     * The IP address to assign to the HSM's ENI.
     * </p>
     * <p>
     * If an IP address is not specified, an IP address will be randomly chosen from the CIDR range of the subnet.
     * </p>
     * 
     * @return The IP address to assign to the HSM's ENI.</p>
     *         <p>
     *         If an IP address is not specified, an IP address will be randomly chosen from the CIDR range of the
     *         subnet.
     */
    public final String eniIp() {
        return eniIp;
    }

    /**
     * <p>
     * The ARN of an IAM role to enable the AWS CloudHSM service to allocate an ENI on your behalf.
     * </p>
     * 
     * @return The ARN of an IAM role to enable the AWS CloudHSM service to allocate an ENI on your behalf.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * The external ID from <code>IamRoleArn</code>, if present.
     * </p>
     * 
     * @return The external ID from <code>IamRoleArn</code>, if present.
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * Returns the value of the SubscriptionType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subscriptionType}
     * will return {@link SubscriptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #subscriptionTypeAsString}.
     * </p>
     * 
     * @return The value of the SubscriptionType property for this object.
     * @see SubscriptionType
     */
    public final SubscriptionType subscriptionType() {
        return SubscriptionType.fromValue(subscriptionType);
    }

    /**
     * Returns the value of the SubscriptionType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subscriptionType}
     * will return {@link SubscriptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #subscriptionTypeAsString}.
     * </p>
     * 
     * @return The value of the SubscriptionType property for this object.
     * @see SubscriptionType
     */
    public final String subscriptionTypeAsString() {
        return subscriptionType;
    }

    /**
     * <p>
     * A user-defined token to ensure idempotence. Subsequent calls to this operation with the same token will be
     * ignored.
     * </p>
     * 
     * @return A user-defined token to ensure idempotence. Subsequent calls to this operation with the same token will
     *         be ignored.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog monitoring
     * server.
     * </p>
     * 
     * @return The IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog
     *         monitoring server.
     */
    public final String syslogIp() {
        return syslogIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(sshKey());
        hashCode = 31 * hashCode + Objects.hashCode(eniIp());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(syslogIp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHsmRequest)) {
            return false;
        }
        CreateHsmRequest other = (CreateHsmRequest) obj;
        return Objects.equals(subnetId(), other.subnetId()) && Objects.equals(sshKey(), other.sshKey())
                && Objects.equals(eniIp(), other.eniIp()) && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(externalId(), other.externalId())
                && Objects.equals(subscriptionTypeAsString(), other.subscriptionTypeAsString())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(syslogIp(), other.syslogIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateHsmRequest").add("SubnetId", subnetId()).add("SshKey", sshKey()).add("EniIp", eniIp())
                .add("IamRoleArn", iamRoleArn()).add("ExternalId", externalId())
                .add("SubscriptionType", subscriptionTypeAsString()).add("ClientToken", clientToken())
                .add("SyslogIp", syslogIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "SshKey":
            return Optional.ofNullable(clazz.cast(sshKey()));
        case "EniIp":
            return Optional.ofNullable(clazz.cast(eniIp()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "ExternalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "SubscriptionType":
            return Optional.ofNullable(clazz.cast(subscriptionTypeAsString()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "SyslogIp":
            return Optional.ofNullable(clazz.cast(syslogIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHsmRequest, T> g) {
        return obj -> g.apply((CreateHsmRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateHsmRequest> {
        /**
         * <p>
         * The identifier of the subnet in your VPC in which to place the HSM.
         * </p>
         * 
         * @param subnetId
         *        The identifier of the subnet in your VPC in which to place the HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The SSH public key to install on the HSM.
         * </p>
         * 
         * @param sshKey
         *        The SSH public key to install on the HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshKey(String sshKey);

        /**
         * <p>
         * The IP address to assign to the HSM's ENI.
         * </p>
         * <p>
         * If an IP address is not specified, an IP address will be randomly chosen from the CIDR range of the subnet.
         * </p>
         * 
         * @param eniIp
         *        The IP address to assign to the HSM's ENI.</p>
         *        <p>
         *        If an IP address is not specified, an IP address will be randomly chosen from the CIDR range of the
         *        subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eniIp(String eniIp);

        /**
         * <p>
         * The ARN of an IAM role to enable the AWS CloudHSM service to allocate an ENI on your behalf.
         * </p>
         * 
         * @param iamRoleArn
         *        The ARN of an IAM role to enable the AWS CloudHSM service to allocate an ENI on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The external ID from <code>IamRoleArn</code>, if present.
         * </p>
         * 
         * @param externalId
         *        The external ID from <code>IamRoleArn</code>, if present.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * Sets the value of the SubscriptionType property for this object.
         *
         * @param subscriptionType
         *        The new value for the SubscriptionType property for this object.
         * @see SubscriptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionType
         */
        Builder subscriptionType(String subscriptionType);

        /**
         * Sets the value of the SubscriptionType property for this object.
         *
         * @param subscriptionType
         *        The new value for the SubscriptionType property for this object.
         * @see SubscriptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionType
         */
        Builder subscriptionType(SubscriptionType subscriptionType);

        /**
         * <p>
         * A user-defined token to ensure idempotence. Subsequent calls to this operation with the same token will be
         * ignored.
         * </p>
         * 
         * @param clientToken
         *        A user-defined token to ensure idempotence. Subsequent calls to this operation with the same token
         *        will be ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog monitoring
         * server.
         * </p>
         * 
         * @param syslogIp
         *        The IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog
         *        monitoring server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syslogIp(String syslogIp);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudHsmRequest.BuilderImpl implements Builder {
        private String subnetId;

        private String sshKey;

        private String eniIp;

        private String iamRoleArn;

        private String externalId;

        private String subscriptionType;

        private String clientToken;

        private String syslogIp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHsmRequest model) {
            super(model);
            subnetId(model.subnetId);
            sshKey(model.sshKey);
            eniIp(model.eniIp);
            iamRoleArn(model.iamRoleArn);
            externalId(model.externalId);
            subscriptionType(model.subscriptionType);
            clientToken(model.clientToken);
            syslogIp(model.syslogIp);
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getSshKey() {
            return sshKey;
        }

        @Override
        public final Builder sshKey(String sshKey) {
            this.sshKey = sshKey;
            return this;
        }

        public final void setSshKey(String sshKey) {
            this.sshKey = sshKey;
        }

        public final String getEniIp() {
            return eniIp;
        }

        @Override
        public final Builder eniIp(String eniIp) {
            this.eniIp = eniIp;
            return this;
        }

        public final void setEniIp(String eniIp) {
            this.eniIp = eniIp;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final String getExternalId() {
            return externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public final String getSubscriptionType() {
            return subscriptionType;
        }

        @Override
        public final Builder subscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
            return this;
        }

        @Override
        public final Builder subscriptionType(SubscriptionType subscriptionType) {
            this.subscriptionType(subscriptionType == null ? null : subscriptionType.toString());
            return this;
        }

        public final void setSubscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getSyslogIp() {
            return syslogIp;
        }

        @Override
        public final Builder syslogIp(String syslogIp) {
            this.syslogIp = syslogIp;
            return this;
        }

        public final void setSyslogIp(String syslogIp) {
            this.syslogIp = syslogIp;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHsmRequest build() {
            return new CreateHsmRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
