/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLunaClientRequest
extends CloudHsmRequest
implements ToCopyableBuilder<Builder, DescribeLunaClientRequest> {
    private static final SdkField<String> CLIENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientArn").getter(DescribeLunaClientRequest.getter(DescribeLunaClientRequest::clientArn)).setter(DescribeLunaClientRequest.setter(Builder::clientArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientArn").build()}).build();
    private static final SdkField<String> CERTIFICATE_FINGERPRINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateFingerprint").getter(DescribeLunaClientRequest.getter(DescribeLunaClientRequest::certificateFingerprint)).setter(DescribeLunaClientRequest.setter(Builder::certificateFingerprint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateFingerprint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ARN_FIELD, CERTIFICATE_FINGERPRINT_FIELD));
    private final String clientArn;
    private final String certificateFingerprint;

    private DescribeLunaClientRequest(BuilderImpl builder) {
        super(builder);
        this.clientArn = builder.clientArn;
        this.certificateFingerprint = builder.certificateFingerprint;
    }

    public String clientArn() {
        return this.clientArn;
    }

    public String certificateFingerprint() {
        return this.certificateFingerprint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateFingerprint());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLunaClientRequest)) {
            return false;
        }
        DescribeLunaClientRequest other = (DescribeLunaClientRequest)((Object)obj);
        return Objects.equals(this.clientArn(), other.clientArn()) && Objects.equals(this.certificateFingerprint(), other.certificateFingerprint());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLunaClientRequest").add("ClientArn", (Object)this.clientArn()).add("CertificateFingerprint", (Object)this.certificateFingerprint()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientArn": {
                return Optional.ofNullable(clazz.cast(this.clientArn()));
            }
            case "CertificateFingerprint": {
                return Optional.ofNullable(clazz.cast(this.certificateFingerprint()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLunaClientRequest, T> g) {
        return obj -> g.apply((DescribeLunaClientRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmRequest.BuilderImpl
    implements Builder {
        private String clientArn;
        private String certificateFingerprint;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLunaClientRequest model) {
            super(model);
            this.clientArn(model.clientArn);
            this.certificateFingerprint(model.certificateFingerprint);
        }

        public final String getClientArn() {
            return this.clientArn;
        }

        @Override
        public final Builder clientArn(String clientArn) {
            this.clientArn = clientArn;
            return this;
        }

        public final void setClientArn(String clientArn) {
            this.clientArn = clientArn;
        }

        public final String getCertificateFingerprint() {
            return this.certificateFingerprint;
        }

        @Override
        public final Builder certificateFingerprint(String certificateFingerprint) {
            this.certificateFingerprint = certificateFingerprint;
            return this;
        }

        public final void setCertificateFingerprint(String certificateFingerprint) {
            this.certificateFingerprint = certificateFingerprint;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLunaClientRequest build() {
            return new DescribeLunaClientRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudHsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLunaClientRequest> {
        public Builder clientArn(String var1);

        public Builder certificateFingerprint(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

