/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyHapgRequest extends CloudHsmRequest implements
        ToCopyableBuilder<ModifyHapgRequest.Builder, ModifyHapgRequest> {
    private static final SdkField<String> HAPG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyHapgRequest::hapgArn)).setter(setter(Builder::hapgArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HapgArn").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyHapgRequest::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<List<String>> PARTITION_SERIAL_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyHapgRequest::partitionSerialList))
            .setter(setter(Builder::partitionSerialList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionSerialList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HAPG_ARN_FIELD, LABEL_FIELD,
            PARTITION_SERIAL_LIST_FIELD));

    private final String hapgArn;

    private final String label;

    private final List<String> partitionSerialList;

    private ModifyHapgRequest(BuilderImpl builder) {
        super(builder);
        this.hapgArn = builder.hapgArn;
        this.label = builder.label;
        this.partitionSerialList = builder.partitionSerialList;
    }

    /**
     * <p>
     * The ARN of the high-availability partition group to modify.
     * </p>
     * 
     * @return The ARN of the high-availability partition group to modify.
     */
    public String hapgArn() {
        return hapgArn;
    }

    /**
     * <p>
     * The new label for the high-availability partition group.
     * </p>
     * 
     * @return The new label for the high-availability partition group.
     */
    public String label() {
        return label;
    }

    /**
     * Returns true if the PartitionSerialList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPartitionSerialList() {
        return partitionSerialList != null && !(partitionSerialList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of partition serial numbers to make members of the high-availability partition group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPartitionSerialList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of partition serial numbers to make members of the high-availability partition group.
     */
    public List<String> partitionSerialList() {
        return partitionSerialList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hapgArn());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(partitionSerialList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyHapgRequest)) {
            return false;
        }
        ModifyHapgRequest other = (ModifyHapgRequest) obj;
        return Objects.equals(hapgArn(), other.hapgArn()) && Objects.equals(label(), other.label())
                && Objects.equals(partitionSerialList(), other.partitionSerialList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyHapgRequest").add("HapgArn", hapgArn()).add("Label", label())
                .add("PartitionSerialList", partitionSerialList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HapgArn":
            return Optional.ofNullable(clazz.cast(hapgArn()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "PartitionSerialList":
            return Optional.ofNullable(clazz.cast(partitionSerialList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyHapgRequest, T> g) {
        return obj -> g.apply((ModifyHapgRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyHapgRequest> {
        /**
         * <p>
         * The ARN of the high-availability partition group to modify.
         * </p>
         * 
         * @param hapgArn
         *        The ARN of the high-availability partition group to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hapgArn(String hapgArn);

        /**
         * <p>
         * The new label for the high-availability partition group.
         * </p>
         * 
         * @param label
         *        The new label for the high-availability partition group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * The list of partition serial numbers to make members of the high-availability partition group.
         * </p>
         * 
         * @param partitionSerialList
         *        The list of partition serial numbers to make members of the high-availability partition group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionSerialList(Collection<String> partitionSerialList);

        /**
         * <p>
         * The list of partition serial numbers to make members of the high-availability partition group.
         * </p>
         * 
         * @param partitionSerialList
         *        The list of partition serial numbers to make members of the high-availability partition group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionSerialList(String... partitionSerialList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudHsmRequest.BuilderImpl implements Builder {
        private String hapgArn;

        private String label;

        private List<String> partitionSerialList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyHapgRequest model) {
            super(model);
            hapgArn(model.hapgArn);
            label(model.label);
            partitionSerialList(model.partitionSerialList);
        }

        public final String getHapgArn() {
            return hapgArn;
        }

        @Override
        public final Builder hapgArn(String hapgArn) {
            this.hapgArn = hapgArn;
            return this;
        }

        public final void setHapgArn(String hapgArn) {
            this.hapgArn = hapgArn;
        }

        public final String getLabel() {
            return label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Collection<String> getPartitionSerialList() {
            return partitionSerialList;
        }

        @Override
        public final Builder partitionSerialList(Collection<String> partitionSerialList) {
            this.partitionSerialList = PartitionSerialListCopier.copy(partitionSerialList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionSerialList(String... partitionSerialList) {
            partitionSerialList(Arrays.asList(partitionSerialList));
            return this;
        }

        public final void setPartitionSerialList(Collection<String> partitionSerialList) {
            this.partitionSerialList = PartitionSerialListCopier.copy(partitionSerialList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyHapgRequest build() {
            return new ModifyHapgRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
