/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLunaClientsResponse extends CloudHsmResponse implements
        ToCopyableBuilder<ListLunaClientsResponse.Builder, ListLunaClientsResponse> {
    private static final SdkField<List<String>> CLIENT_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListLunaClientsResponse::clientList))
            .setter(setter(Builder::clientList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListLunaClientsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> clientList;

    private final String nextToken;

    private ListLunaClientsResponse(BuilderImpl builder) {
        super(builder);
        this.clientList = builder.clientList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ClientList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasClientList() {
        return clientList != null && !(clientList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of clients.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasClientList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of clients.
     */
    public List<String> clientList() {
        return clientList;
    }

    /**
     * <p>
     * If not null, more results are available. Pass this to <code>ListLunaClients</code> to retrieve the next set of
     * items.
     * </p>
     * 
     * @return If not null, more results are available. Pass this to <code>ListLunaClients</code> to retrieve the next
     *         set of items.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLunaClientsResponse)) {
            return false;
        }
        ListLunaClientsResponse other = (ListLunaClientsResponse) obj;
        return Objects.equals(clientList(), other.clientList()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListLunaClientsResponse").add("ClientList", clientList()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientList":
            return Optional.ofNullable(clazz.cast(clientList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLunaClientsResponse, T> g) {
        return obj -> g.apply((ListLunaClientsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListLunaClientsResponse> {
        /**
         * <p>
         * The list of clients.
         * </p>
         * 
         * @param clientList
         *        The list of clients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientList(Collection<String> clientList);

        /**
         * <p>
         * The list of clients.
         * </p>
         * 
         * @param clientList
         *        The list of clients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientList(String... clientList);

        /**
         * <p>
         * If not null, more results are available. Pass this to <code>ListLunaClients</code> to retrieve the next set
         * of items.
         * </p>
         * 
         * @param nextToken
         *        If not null, more results are available. Pass this to <code>ListLunaClients</code> to retrieve the
         *        next set of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudHsmResponse.BuilderImpl implements Builder {
        private List<String> clientList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLunaClientsResponse model) {
            super(model);
            clientList(model.clientList);
            nextToken(model.nextToken);
        }

        public final Collection<String> getClientList() {
            return clientList;
        }

        @Override
        public final Builder clientList(Collection<String> clientList) {
            this.clientList = ClientListCopier.copy(clientList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientList(String... clientList) {
            clientList(Arrays.asList(clientList));
            return this;
        }

        public final void setClientList(Collection<String> clientList) {
            this.clientList = ClientListCopier.copy(clientList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListLunaClientsResponse build() {
            return new ListLunaClientsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
