/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAvailableZonesResponse extends CloudHsmResponse implements
        ToCopyableBuilder<ListAvailableZonesResponse.Builder, ListAvailableZonesResponse> {
    private static final SdkField<List<String>> AZ_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListAvailableZonesResponse::azList))
            .setter(setter(Builder::azList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AZList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AZ_LIST_FIELD));

    private final List<String> azList;

    private ListAvailableZonesResponse(BuilderImpl builder) {
        super(builder);
        this.azList = builder.azList;
    }

    /**
     * Returns true if the AZList property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAzList() {
        return azList != null && !(azList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Availability Zones that have available AWS CloudHSM capacity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAzList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of Availability Zones that have available AWS CloudHSM capacity.
     */
    public List<String> azList() {
        return azList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(azList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAvailableZonesResponse)) {
            return false;
        }
        ListAvailableZonesResponse other = (ListAvailableZonesResponse) obj;
        return Objects.equals(azList(), other.azList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListAvailableZonesResponse").add("AZList", azList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AZList":
            return Optional.ofNullable(clazz.cast(azList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAvailableZonesResponse, T> g) {
        return obj -> g.apply((ListAvailableZonesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAvailableZonesResponse> {
        /**
         * <p>
         * The list of Availability Zones that have available AWS CloudHSM capacity.
         * </p>
         * 
         * @param azList
         *        The list of Availability Zones that have available AWS CloudHSM capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder azList(Collection<String> azList);

        /**
         * <p>
         * The list of Availability Zones that have available AWS CloudHSM capacity.
         * </p>
         * 
         * @param azList
         *        The list of Availability Zones that have available AWS CloudHSM capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder azList(String... azList);
    }

    static final class BuilderImpl extends CloudHsmResponse.BuilderImpl implements Builder {
        private List<String> azList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAvailableZonesResponse model) {
            super(model);
            azList(model.azList);
        }

        public final Collection<String> getAzList() {
            return azList;
        }

        @Override
        public final Builder azList(Collection<String> azList) {
            this.azList = AZListCopier.copy(azList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder azList(String... azList) {
            azList(Arrays.asList(azList));
            return this;
        }

        public final void setAzList(Collection<String> azList) {
            this.azList = AZListCopier.copy(azList);
        }

        @Override
        public ListAvailableZonesResponse build() {
            return new ListAvailableZonesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
