/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsm;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.cloudhsm.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.cloudhsm.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmException;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmInternalException;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmServiceException;
import software.amazon.awssdk.services.cloudhsm.model.CreateHapgRequest;
import software.amazon.awssdk.services.cloudhsm.model.CreateHapgResponse;
import software.amazon.awssdk.services.cloudhsm.model.CreateHsmRequest;
import software.amazon.awssdk.services.cloudhsm.model.CreateHsmResponse;
import software.amazon.awssdk.services.cloudhsm.model.CreateLunaClientRequest;
import software.amazon.awssdk.services.cloudhsm.model.CreateLunaClientResponse;
import software.amazon.awssdk.services.cloudhsm.model.DeleteHapgRequest;
import software.amazon.awssdk.services.cloudhsm.model.DeleteHapgResponse;
import software.amazon.awssdk.services.cloudhsm.model.DeleteHsmRequest;
import software.amazon.awssdk.services.cloudhsm.model.DeleteHsmResponse;
import software.amazon.awssdk.services.cloudhsm.model.DeleteLunaClientRequest;
import software.amazon.awssdk.services.cloudhsm.model.DeleteLunaClientResponse;
import software.amazon.awssdk.services.cloudhsm.model.DescribeHapgRequest;
import software.amazon.awssdk.services.cloudhsm.model.DescribeHapgResponse;
import software.amazon.awssdk.services.cloudhsm.model.DescribeHsmRequest;
import software.amazon.awssdk.services.cloudhsm.model.DescribeHsmResponse;
import software.amazon.awssdk.services.cloudhsm.model.DescribeLunaClientRequest;
import software.amazon.awssdk.services.cloudhsm.model.DescribeLunaClientResponse;
import software.amazon.awssdk.services.cloudhsm.model.GetConfigRequest;
import software.amazon.awssdk.services.cloudhsm.model.GetConfigResponse;
import software.amazon.awssdk.services.cloudhsm.model.InvalidRequestException;
import software.amazon.awssdk.services.cloudhsm.model.ListAvailableZonesRequest;
import software.amazon.awssdk.services.cloudhsm.model.ListAvailableZonesResponse;
import software.amazon.awssdk.services.cloudhsm.model.ListHapgsRequest;
import software.amazon.awssdk.services.cloudhsm.model.ListHapgsResponse;
import software.amazon.awssdk.services.cloudhsm.model.ListHsmsRequest;
import software.amazon.awssdk.services.cloudhsm.model.ListHsmsResponse;
import software.amazon.awssdk.services.cloudhsm.model.ListLunaClientsRequest;
import software.amazon.awssdk.services.cloudhsm.model.ListLunaClientsResponse;
import software.amazon.awssdk.services.cloudhsm.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudhsm.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudhsm.model.ModifyHapgRequest;
import software.amazon.awssdk.services.cloudhsm.model.ModifyHapgResponse;
import software.amazon.awssdk.services.cloudhsm.model.ModifyHsmRequest;
import software.amazon.awssdk.services.cloudhsm.model.ModifyHsmResponse;
import software.amazon.awssdk.services.cloudhsm.model.ModifyLunaClientRequest;
import software.amazon.awssdk.services.cloudhsm.model.ModifyLunaClientResponse;
import software.amazon.awssdk.services.cloudhsm.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.cloudhsm.model.RemoveTagsFromResourceResponse;

/**
 * Service client for accessing CloudHSM. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AWS CloudHSM Service</fullname>
 * <p>
 * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
 * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
 * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
 * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
 * </p>
 * <p>
 * <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS
 * CloudHSM</a>, the <a href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and
 * the <a href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface CloudHsmClient extends SdkClient {
    String SERVICE_NAME = "cloudhsm";

    /**
     * Create a {@link CloudHsmClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CloudHsmClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CloudHsmClient}.
     */
    static CloudHsmClientBuilder builder() {
        return new DefaultCloudHsmClientBuilder();
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Adds or overwrites one or more tags for the specified AWS CloudHSM resource.
     * </p>
     * <p>
     * Each tag consists of a key and a value. Tag keys must be unique to each resource.
     * </p>
     *
     * @param addTagsToResourceRequest
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.AddTagsToResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest)
            throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException,
            SdkClientException, CloudHsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Adds or overwrites one or more tags for the specified AWS CloudHSM resource.
     * </p>
     * <p>
     * Each tag consists of a key and a value. Tag keys must be unique to each resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsToResourceRequest.Builder} avoiding the need
     * to create one manually via {@link AddTagsToResourceRequest#builder()}
     * </p>
     *
     * @param addTagsToResourceRequest
     *        A {@link Consumer} that will call methods on {@link AddTagsToResourceRequest.Builder} to create a request.
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.AddTagsToResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default AddTagsToResourceResponse addTagsToResource(Consumer<AddTagsToResourceRequest.Builder> addTagsToResourceRequest)
            throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException,
            SdkClientException, CloudHsmException {
        return addTagsToResource(AddTagsToResourceRequest.builder().applyMutation(addTagsToResourceRequest).build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Creates a high-availability partition group. A high-availability partition group is a group of partitions that
     * spans multiple physical HSMs.
     * </p>
     *
     * @param createHapgRequest
     *        Contains the inputs for the <a>CreateHapgRequest</a> action.
     * @return Result of the CreateHapg operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.CreateHapg
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/CreateHapg" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateHapgResponse createHapg(CreateHapgRequest createHapgRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Creates a high-availability partition group. A high-availability partition group is a group of partitions that
     * spans multiple physical HSMs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHapgRequest.Builder} avoiding the need to
     * create one manually via {@link CreateHapgRequest#builder()}
     * </p>
     *
     * @param createHapgRequest
     *        A {@link Consumer} that will call methods on {@link CreateHapgRequest.Builder} to create a request.
     *        Contains the inputs for the <a>CreateHapgRequest</a> action.
     * @return Result of the CreateHapg operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.CreateHapg
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/CreateHapg" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateHapgResponse createHapg(Consumer<CreateHapgRequest.Builder> createHapgRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        return createHapg(CreateHapgRequest.builder().applyMutation(createHapgRequest).build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Creates an uninitialized HSM instance.
     * </p>
     * <p>
     * There is an upfront fee charged for each HSM instance that you create with the <code>CreateHsm</code> operation.
     * If you accidentally provision an HSM and want to request a refund, delete the instance using the <a>DeleteHsm</a>
     * operation, go to the <a href="https://console.aws.amazon.com/support/home">AWS Support Center</a>, create a new
     * case, and select <b>Account and Billing Support</b>.
     * </p>
     * <important>
     * <p>
     * It can take up to 20 minutes to create and provision an HSM. You can monitor the status of the HSM with the
     * <a>DescribeHsm</a> operation. The HSM is ready to be initialized when the status changes to <code>RUNNING</code>.
     * </p>
     * </important>
     *
     * @param createHsmRequest
     *        Contains the inputs for the <code>CreateHsm</code> operation.
     * @return Result of the CreateHsm operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.CreateHsm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/CreateHsm" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateHsmResponse createHsm(CreateHsmRequest createHsmRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Creates an uninitialized HSM instance.
     * </p>
     * <p>
     * There is an upfront fee charged for each HSM instance that you create with the <code>CreateHsm</code> operation.
     * If you accidentally provision an HSM and want to request a refund, delete the instance using the <a>DeleteHsm</a>
     * operation, go to the <a href="https://console.aws.amazon.com/support/home">AWS Support Center</a>, create a new
     * case, and select <b>Account and Billing Support</b>.
     * </p>
     * <important>
     * <p>
     * It can take up to 20 minutes to create and provision an HSM. You can monitor the status of the HSM with the
     * <a>DescribeHsm</a> operation. The HSM is ready to be initialized when the status changes to <code>RUNNING</code>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHsmRequest.Builder} avoiding the need to
     * create one manually via {@link CreateHsmRequest#builder()}
     * </p>
     *
     * @param createHsmRequest
     *        A {@link Consumer} that will call methods on {@link CreateHsmRequest.Builder} to create a request.
     *        Contains the inputs for the <code>CreateHsm</code> operation.
     * @return Result of the CreateHsm operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.CreateHsm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/CreateHsm" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateHsmResponse createHsm(Consumer<CreateHsmRequest.Builder> createHsmRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        return createHsm(CreateHsmRequest.builder().applyMutation(createHsmRequest).build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Creates an HSM client.
     * </p>
     *
     * @param createLunaClientRequest
     *        Contains the inputs for the <a>CreateLunaClient</a> action.
     * @return Result of the CreateLunaClient operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.CreateLunaClient
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/CreateLunaClient" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLunaClientResponse createLunaClient(CreateLunaClientRequest createLunaClientRequest)
            throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException,
            SdkClientException, CloudHsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Creates an HSM client.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLunaClientRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLunaClientRequest#builder()}
     * </p>
     *
     * @param createLunaClientRequest
     *        A {@link Consumer} that will call methods on {@link CreateLunaClientRequest.Builder} to create a request.
     *        Contains the inputs for the <a>CreateLunaClient</a> action.
     * @return Result of the CreateLunaClient operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.CreateLunaClient
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/CreateLunaClient" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLunaClientResponse createLunaClient(Consumer<CreateLunaClientRequest.Builder> createLunaClientRequest)
            throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException,
            SdkClientException, CloudHsmException {
        return createLunaClient(CreateLunaClientRequest.builder().applyMutation(createLunaClientRequest).build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Deletes a high-availability partition group.
     * </p>
     *
     * @param deleteHapgRequest
     *        Contains the inputs for the <a>DeleteHapg</a> action.
     * @return Result of the DeleteHapg operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.DeleteHapg
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteHapg" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteHapgResponse deleteHapg(DeleteHapgRequest deleteHapgRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Deletes a high-availability partition group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHapgRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteHapgRequest#builder()}
     * </p>
     *
     * @param deleteHapgRequest
     *        A {@link Consumer} that will call methods on {@link DeleteHapgRequest.Builder} to create a request.
     *        Contains the inputs for the <a>DeleteHapg</a> action.
     * @return Result of the DeleteHapg operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.DeleteHapg
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteHapg" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteHapgResponse deleteHapg(Consumer<DeleteHapgRequest.Builder> deleteHapgRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        return deleteHapg(DeleteHapgRequest.builder().applyMutation(deleteHapgRequest).build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Deletes an HSM. After completion, this operation cannot be undone and your key material cannot be recovered.
     * </p>
     *
     * @param deleteHsmRequest
     *        Contains the inputs for the <a>DeleteHsm</a> operation.
     * @return Result of the DeleteHsm operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.DeleteHsm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteHsm" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteHsmResponse deleteHsm(DeleteHsmRequest deleteHsmRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Deletes an HSM. After completion, this operation cannot be undone and your key material cannot be recovered.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHsmRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteHsmRequest#builder()}
     * </p>
     *
     * @param deleteHsmRequest
     *        A {@link Consumer} that will call methods on {@link DeleteHsmRequest.Builder} to create a request.
     *        Contains the inputs for the <a>DeleteHsm</a> operation.
     * @return Result of the DeleteHsm operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.DeleteHsm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteHsm" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteHsmResponse deleteHsm(Consumer<DeleteHsmRequest.Builder> deleteHsmRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        return deleteHsm(DeleteHsmRequest.builder().applyMutation(deleteHsmRequest).build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Deletes a client.
     * </p>
     *
     * @param deleteLunaClientRequest
     * @return Result of the DeleteLunaClient operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.DeleteLunaClient
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteLunaClient" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLunaClientResponse deleteLunaClient(DeleteLunaClientRequest deleteLunaClientRequest)
            throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException,
            SdkClientException, CloudHsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Deletes a client.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLunaClientRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteLunaClientRequest#builder()}
     * </p>
     *
     * @param deleteLunaClientRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLunaClientRequest.Builder} to create a request.
     * @return Result of the DeleteLunaClient operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.DeleteLunaClient
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteLunaClient" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLunaClientResponse deleteLunaClient(Consumer<DeleteLunaClientRequest.Builder> deleteLunaClientRequest)
            throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException,
            SdkClientException, CloudHsmException {
        return deleteLunaClient(DeleteLunaClientRequest.builder().applyMutation(deleteLunaClientRequest).build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Retrieves information about a high-availability partition group.
     * </p>
     *
     * @param describeHapgRequest
     *        Contains the inputs for the <a>DescribeHapg</a> action.
     * @return Result of the DescribeHapg operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.DescribeHapg
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeHapg" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeHapgResponse describeHapg(DescribeHapgRequest describeHapgRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Retrieves information about a high-availability partition group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHapgRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeHapgRequest#builder()}
     * </p>
     *
     * @param describeHapgRequest
     *        A {@link Consumer} that will call methods on {@link DescribeHapgRequest.Builder} to create a request.
     *        Contains the inputs for the <a>DescribeHapg</a> action.
     * @return Result of the DescribeHapg operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.DescribeHapg
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeHapg" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeHapgResponse describeHapg(Consumer<DescribeHapgRequest.Builder> describeHapgRequest)
            throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException,
            SdkClientException, CloudHsmException {
        return describeHapg(DescribeHapgRequest.builder().applyMutation(describeHapgRequest).build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Retrieves information about an HSM. You can identify the HSM by its ARN or its serial number.
     * </p>
     *
     * @param describeHsmRequest
     *        Contains the inputs for the <a>DescribeHsm</a> operation.
     * @return Result of the DescribeHsm operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.DescribeHsm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeHsm" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeHsmResponse describeHsm(DescribeHsmRequest describeHsmRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Retrieves information about an HSM. You can identify the HSM by its ARN or its serial number.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHsmRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeHsmRequest#builder()}
     * </p>
     *
     * @param describeHsmRequest
     *        A {@link Consumer} that will call methods on {@link DescribeHsmRequest.Builder} to create a request.
     *        Contains the inputs for the <a>DescribeHsm</a> operation.
     * @return Result of the DescribeHsm operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.DescribeHsm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeHsm" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeHsmResponse describeHsm(Consumer<DescribeHsmRequest.Builder> describeHsmRequest)
            throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException,
            SdkClientException, CloudHsmException {
        return describeHsm(DescribeHsmRequest.builder().applyMutation(describeHsmRequest).build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Retrieves information about an HSM client.
     * </p>
     *
     * @param describeLunaClientRequest
     * @return Result of the DescribeLunaClient operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.DescribeLunaClient
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeLunaClient" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeLunaClientResponse describeLunaClient(DescribeLunaClientRequest describeLunaClientRequest)
            throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException,
            SdkClientException, CloudHsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Retrieves information about an HSM client.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLunaClientRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLunaClientRequest#builder()}
     * </p>
     *
     * @param describeLunaClientRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLunaClientRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeLunaClient operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.DescribeLunaClient
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeLunaClient" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeLunaClientResponse describeLunaClient(Consumer<DescribeLunaClientRequest.Builder> describeLunaClientRequest)
            throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException,
            SdkClientException, CloudHsmException {
        return describeLunaClient(DescribeLunaClientRequest.builder().applyMutation(describeLunaClientRequest).build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Gets the configuration files necessary to connect to all high availability partition groups the client is
     * associated with.
     * </p>
     *
     * @param getConfigRequest
     * @return Result of the GetConfig operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.GetConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/GetConfig" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConfigResponse getConfig(GetConfigRequest getConfigRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Gets the configuration files necessary to connect to all high availability partition groups the client is
     * associated with.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfigRequest.Builder} avoiding the need to
     * create one manually via {@link GetConfigRequest#builder()}
     * </p>
     *
     * @param getConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetConfigRequest.Builder} to create a request.
     * @return Result of the GetConfig operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.GetConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/GetConfig" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConfigResponse getConfig(Consumer<GetConfigRequest.Builder> getConfigRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        return getConfig(GetConfigRequest.builder().applyMutation(getConfigRequest).build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Lists the Availability Zones that have available AWS CloudHSM capacity.
     * </p>
     *
     * @return Result of the ListAvailableZones operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.ListAvailableZones
     * @see #listAvailableZones(ListAvailableZonesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListAvailableZones" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAvailableZonesResponse listAvailableZones() throws CloudHsmServiceException, CloudHsmInternalException,
            InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        return listAvailableZones(ListAvailableZonesRequest.builder().build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Lists the Availability Zones that have available AWS CloudHSM capacity.
     * </p>
     *
     * @param listAvailableZonesRequest
     *        Contains the inputs for the <a>ListAvailableZones</a> action.
     * @return Result of the ListAvailableZones operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.ListAvailableZones
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListAvailableZones" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAvailableZonesResponse listAvailableZones(ListAvailableZonesRequest listAvailableZonesRequest)
            throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException,
            SdkClientException, CloudHsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Lists the Availability Zones that have available AWS CloudHSM capacity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailableZonesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAvailableZonesRequest#builder()}
     * </p>
     *
     * @param listAvailableZonesRequest
     *        A {@link Consumer} that will call methods on {@link ListAvailableZonesRequest.Builder} to create a
     *        request. Contains the inputs for the <a>ListAvailableZones</a> action.
     * @return Result of the ListAvailableZones operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.ListAvailableZones
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListAvailableZones" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAvailableZonesResponse listAvailableZones(Consumer<ListAvailableZonesRequest.Builder> listAvailableZonesRequest)
            throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException,
            SdkClientException, CloudHsmException {
        return listAvailableZones(ListAvailableZonesRequest.builder().applyMutation(listAvailableZonesRequest).build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Lists the high-availability partition groups for the account.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> member. If more results are
     * available, the <code>NextToken</code> member of the response contains a token that you pass in the next call to
     * <code>ListHapgs</code> to retrieve the next set of items.
     * </p>
     *
     * @return Result of the ListHapgs operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.ListHapgs
     * @see #listHapgs(ListHapgsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListHapgs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListHapgsResponse listHapgs() throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException,
            AwsServiceException, SdkClientException, CloudHsmException {
        return listHapgs(ListHapgsRequest.builder().build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Lists the high-availability partition groups for the account.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> member. If more results are
     * available, the <code>NextToken</code> member of the response contains a token that you pass in the next call to
     * <code>ListHapgs</code> to retrieve the next set of items.
     * </p>
     *
     * @param listHapgsRequest
     * @return Result of the ListHapgs operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.ListHapgs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListHapgs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListHapgsResponse listHapgs(ListHapgsRequest listHapgsRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Lists the high-availability partition groups for the account.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> member. If more results are
     * available, the <code>NextToken</code> member of the response contains a token that you pass in the next call to
     * <code>ListHapgs</code> to retrieve the next set of items.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHapgsRequest.Builder} avoiding the need to
     * create one manually via {@link ListHapgsRequest#builder()}
     * </p>
     *
     * @param listHapgsRequest
     *        A {@link Consumer} that will call methods on {@link ListHapgsRequest.Builder} to create a request.
     * @return Result of the ListHapgs operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.ListHapgs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListHapgs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListHapgsResponse listHapgs(Consumer<ListHapgsRequest.Builder> listHapgsRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        return listHapgs(ListHapgsRequest.builder().applyMutation(listHapgsRequest).build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Retrieves the identifiers of all of the HSMs provisioned for the current customer.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> member. If more results are
     * available, the <code>NextToken</code> member of the response contains a token that you pass in the next call to
     * <code>ListHsms</code> to retrieve the next set of items.
     * </p>
     *
     * @return Result of the ListHsms operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.ListHsms
     * @see #listHsms(ListHsmsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListHsms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListHsmsResponse listHsms() throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException,
            AwsServiceException, SdkClientException, CloudHsmException {
        return listHsms(ListHsmsRequest.builder().build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Retrieves the identifiers of all of the HSMs provisioned for the current customer.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> member. If more results are
     * available, the <code>NextToken</code> member of the response contains a token that you pass in the next call to
     * <code>ListHsms</code> to retrieve the next set of items.
     * </p>
     *
     * @param listHsmsRequest
     * @return Result of the ListHsms operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.ListHsms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListHsms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListHsmsResponse listHsms(ListHsmsRequest listHsmsRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Retrieves the identifiers of all of the HSMs provisioned for the current customer.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> member. If more results are
     * available, the <code>NextToken</code> member of the response contains a token that you pass in the next call to
     * <code>ListHsms</code> to retrieve the next set of items.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHsmsRequest.Builder} avoiding the need to
     * create one manually via {@link ListHsmsRequest#builder()}
     * </p>
     *
     * @param listHsmsRequest
     *        A {@link Consumer} that will call methods on {@link ListHsmsRequest.Builder} to create a request.
     * @return Result of the ListHsms operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.ListHsms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListHsms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListHsmsResponse listHsms(Consumer<ListHsmsRequest.Builder> listHsmsRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        return listHsms(ListHsmsRequest.builder().applyMutation(listHsmsRequest).build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Lists all of the clients.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> member. If more results are
     * available, the <code>NextToken</code> member of the response contains a token that you pass in the next call to
     * <code>ListLunaClients</code> to retrieve the next set of items.
     * </p>
     *
     * @return Result of the ListLunaClients operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.ListLunaClients
     * @see #listLunaClients(ListLunaClientsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListLunaClients" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLunaClientsResponse listLunaClients() throws CloudHsmServiceException, CloudHsmInternalException,
            InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        return listLunaClients(ListLunaClientsRequest.builder().build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Lists all of the clients.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> member. If more results are
     * available, the <code>NextToken</code> member of the response contains a token that you pass in the next call to
     * <code>ListLunaClients</code> to retrieve the next set of items.
     * </p>
     *
     * @param listLunaClientsRequest
     * @return Result of the ListLunaClients operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.ListLunaClients
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListLunaClients" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLunaClientsResponse listLunaClients(ListLunaClientsRequest listLunaClientsRequest)
            throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException,
            SdkClientException, CloudHsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Lists all of the clients.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> member. If more results are
     * available, the <code>NextToken</code> member of the response contains a token that you pass in the next call to
     * <code>ListLunaClients</code> to retrieve the next set of items.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLunaClientsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLunaClientsRequest#builder()}
     * </p>
     *
     * @param listLunaClientsRequest
     *        A {@link Consumer} that will call methods on {@link ListLunaClientsRequest.Builder} to create a request.
     * @return Result of the ListLunaClients operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.ListLunaClients
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListLunaClients" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLunaClientsResponse listLunaClients(Consumer<ListLunaClientsRequest.Builder> listLunaClientsRequest)
            throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException,
            SdkClientException, CloudHsmException {
        return listLunaClients(ListLunaClientsRequest.builder().applyMutation(listLunaClientsRequest).build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Returns a list of all tags for the specified AWS CloudHSM resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException,
            SdkClientException, CloudHsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Returns a list of all tags for the specified AWS CloudHSM resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Modifies an existing high-availability partition group.
     * </p>
     *
     * @param modifyHapgRequest
     * @return Result of the ModifyHapg operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.ModifyHapg
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyHapg" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyHapgResponse modifyHapg(ModifyHapgRequest modifyHapgRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Modifies an existing high-availability partition group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyHapgRequest.Builder} avoiding the need to
     * create one manually via {@link ModifyHapgRequest#builder()}
     * </p>
     *
     * @param modifyHapgRequest
     *        A {@link Consumer} that will call methods on {@link ModifyHapgRequest.Builder} to create a request.
     * @return Result of the ModifyHapg operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.ModifyHapg
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyHapg" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyHapgResponse modifyHapg(Consumer<ModifyHapgRequest.Builder> modifyHapgRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        return modifyHapg(ModifyHapgRequest.builder().applyMutation(modifyHapgRequest).build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Modifies an HSM.
     * </p>
     * <important>
     * <p>
     * This operation can result in the HSM being offline for up to 15 minutes while the AWS CloudHSM service is
     * reconfigured. If you are modifying a production HSM, you should ensure that your AWS CloudHSM service is
     * configured for high availability, and consider executing this operation during a maintenance window.
     * </p>
     * </important>
     *
     * @param modifyHsmRequest
     *        Contains the inputs for the <a>ModifyHsm</a> operation.
     * @return Result of the ModifyHsm operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.ModifyHsm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyHsm" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyHsmResponse modifyHsm(ModifyHsmRequest modifyHsmRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Modifies an HSM.
     * </p>
     * <important>
     * <p>
     * This operation can result in the HSM being offline for up to 15 minutes while the AWS CloudHSM service is
     * reconfigured. If you are modifying a production HSM, you should ensure that your AWS CloudHSM service is
     * configured for high availability, and consider executing this operation during a maintenance window.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyHsmRequest.Builder} avoiding the need to
     * create one manually via {@link ModifyHsmRequest#builder()}
     * </p>
     *
     * @param modifyHsmRequest
     *        A {@link Consumer} that will call methods on {@link ModifyHsmRequest.Builder} to create a request.
     *        Contains the inputs for the <a>ModifyHsm</a> operation.
     * @return Result of the ModifyHsm operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.ModifyHsm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyHsm" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyHsmResponse modifyHsm(Consumer<ModifyHsmRequest.Builder> modifyHsmRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        return modifyHsm(ModifyHsmRequest.builder().applyMutation(modifyHsmRequest).build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Modifies the certificate used by the client.
     * </p>
     * <p>
     * This action can potentially start a workflow to install the new certificate on the client's HSMs.
     * </p>
     *
     * @param modifyLunaClientRequest
     * @return Result of the ModifyLunaClient operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.ModifyLunaClient
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyLunaClient" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyLunaClientResponse modifyLunaClient(ModifyLunaClientRequest modifyLunaClientRequest)
            throws CloudHsmServiceException, AwsServiceException, SdkClientException, CloudHsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Modifies the certificate used by the client.
     * </p>
     * <p>
     * This action can potentially start a workflow to install the new certificate on the client's HSMs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyLunaClientRequest.Builder} avoiding the need
     * to create one manually via {@link ModifyLunaClientRequest#builder()}
     * </p>
     *
     * @param modifyLunaClientRequest
     *        A {@link Consumer} that will call methods on {@link ModifyLunaClientRequest.Builder} to create a request.
     * @return Result of the ModifyLunaClient operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.ModifyLunaClient
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyLunaClient" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyLunaClientResponse modifyLunaClient(Consumer<ModifyLunaClientRequest.Builder> modifyLunaClientRequest)
            throws CloudHsmServiceException, AwsServiceException, SdkClientException, CloudHsmException {
        return modifyLunaClient(ModifyLunaClientRequest.builder().applyMutation(modifyLunaClientRequest).build());
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Removes one or more tags from the specified AWS CloudHSM resource.
     * </p>
     * <p>
     * To remove a tag, specify only the tag key to remove (not the value). To overwrite the value for an existing tag,
     * use <a>AddTagsToResource</a>.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     * @return Result of the RemoveTagsFromResource operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.RemoveTagsFromResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/RemoveTagsFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest)
            throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException,
            SdkClientException, CloudHsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a
     * href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.
     * </p>
     * <p>
     * <b>For information about the current version of AWS CloudHSM</b>, see <a
     * href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a
     * href="http://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.
     * </p>
     * <p>
     * Removes one or more tags from the specified AWS CloudHSM resource.
     * </p>
     * <p>
     * To remove a tag, specify only the tag key to remove (not the value). To overwrite the value for an existing tag,
     * use <a>AddTagsToResource</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsFromResourceRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveTagsFromResourceRequest#builder()}
     * </p>
     *
     * @param removeTagsFromResourceRequest
     *        A {@link Consumer} that will call methods on {@link RemoveTagsFromResourceRequest.Builder} to create a
     *        request.
     * @return Result of the RemoveTagsFromResource operation returned by the service.
     * @throws CloudHsmServiceException
     *         Indicates that an exception occurred in the AWS CloudHSM service.
     * @throws CloudHsmInternalException
     *         Indicates that an internal error occurred.
     * @throws InvalidRequestException
     *         Indicates that one or more of the request parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudHsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudHsmClient.RemoveTagsFromResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/RemoveTagsFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveTagsFromResourceResponse removeTagsFromResource(
            Consumer<RemoveTagsFromResourceRequest.Builder> removeTagsFromResourceRequest) throws CloudHsmServiceException,
            CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        return removeTagsFromResource(RemoveTagsFromResourceRequest.builder().applyMutation(removeTagsFromResourceRequest)
                .build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("cloudhsm");
    }
}
