/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudhsm.model.ClientVersion;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmRequest;
import software.amazon.awssdk.services.cloudhsm.model.HapgListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConfigRequest
extends CloudHsmRequest
implements ToCopyableBuilder<Builder, GetConfigRequest> {
    private static final SdkField<String> CLIENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetConfigRequest.getter(GetConfigRequest::clientArn)).setter(GetConfigRequest.setter(Builder::clientArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientArn").build()}).build();
    private static final SdkField<String> CLIENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetConfigRequest.getter(GetConfigRequest::clientVersionAsString)).setter(GetConfigRequest.setter(Builder::clientVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVersion").build()}).build();
    private static final SdkField<List<String>> HAPG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetConfigRequest.getter(GetConfigRequest::hapgList)).setter(GetConfigRequest.setter(Builder::hapgList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HapgList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ARN_FIELD, CLIENT_VERSION_FIELD, HAPG_LIST_FIELD));
    private final String clientArn;
    private final String clientVersion;
    private final List<String> hapgList;

    private GetConfigRequest(BuilderImpl builder) {
        super(builder);
        this.clientArn = builder.clientArn;
        this.clientVersion = builder.clientVersion;
        this.hapgList = builder.hapgList;
    }

    public String clientArn() {
        return this.clientArn;
    }

    public ClientVersion clientVersion() {
        return ClientVersion.fromValue(this.clientVersion);
    }

    public String clientVersionAsString() {
        return this.clientVersion;
    }

    public List<String> hapgList() {
        return this.hapgList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hapgList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigRequest)) {
            return false;
        }
        GetConfigRequest other = (GetConfigRequest)((Object)obj);
        return Objects.equals(this.clientArn(), other.clientArn()) && Objects.equals(this.clientVersionAsString(), other.clientVersionAsString()) && Objects.equals(this.hapgList(), other.hapgList());
    }

    public String toString() {
        return ToString.builder((String)"GetConfigRequest").add("ClientArn", (Object)this.clientArn()).add("ClientVersion", (Object)this.clientVersionAsString()).add("HapgList", this.hapgList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientArn": {
                return Optional.ofNullable(clazz.cast(this.clientArn()));
            }
            case "ClientVersion": {
                return Optional.ofNullable(clazz.cast(this.clientVersionAsString()));
            }
            case "HapgList": {
                return Optional.ofNullable(clazz.cast(this.hapgList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConfigRequest, T> g) {
        return obj -> g.apply((GetConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmRequest.BuilderImpl
    implements Builder {
        private String clientArn;
        private String clientVersion;
        private List<String> hapgList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigRequest model) {
            super(model);
            this.clientArn(model.clientArn);
            this.clientVersion(model.clientVersion);
            this.hapgList(model.hapgList);
        }

        public final String getClientArn() {
            return this.clientArn;
        }

        @Override
        public final Builder clientArn(String clientArn) {
            this.clientArn = clientArn;
            return this;
        }

        public final void setClientArn(String clientArn) {
            this.clientArn = clientArn;
        }

        public final String getClientVersionAsString() {
            return this.clientVersion;
        }

        @Override
        public final Builder clientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
            return this;
        }

        @Override
        public final Builder clientVersion(ClientVersion clientVersion) {
            this.clientVersion(clientVersion == null ? null : clientVersion.toString());
            return this;
        }

        public final void setClientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
        }

        public final Collection<String> getHapgList() {
            return this.hapgList;
        }

        @Override
        public final Builder hapgList(Collection<String> hapgList) {
            this.hapgList = HapgListCopier.copy(hapgList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hapgList(String ... hapgList) {
            this.hapgList(Arrays.asList(hapgList));
            return this;
        }

        public final void setHapgList(Collection<String> hapgList) {
            this.hapgList = HapgListCopier.copy(hapgList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetConfigRequest build() {
            return new GetConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudHsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConfigRequest> {
        public Builder clientArn(String var1);

        public Builder clientVersion(String var1);

        public Builder clientVersion(ClientVersion var1);

        public Builder hapgList(Collection<String> var1);

        public Builder hapgList(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

