/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ClientVersion {
    FIVE_ONE("5.1"),
    FIVE_THREE("5.3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ClientVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ClientVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ClientVersion.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ClientVersion> knownValues() {
        return Stream.of(ClientVersion.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

