/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfrontkeyvaluestore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.CloudFrontKeyValueStoreResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateKeysResponse
extends CloudFrontKeyValueStoreResponse
implements ToCopyableBuilder<Builder, UpdateKeysResponse> {
    private static final SdkField<Integer> ITEM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ItemCount").getter(UpdateKeysResponse.getter(UpdateKeysResponse::itemCount)).setter(UpdateKeysResponse.setter(Builder::itemCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()}).build();
    private static final SdkField<Long> TOTAL_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalSizeInBytes").getter(UpdateKeysResponse.getter(UpdateKeysResponse::totalSizeInBytes)).setter(UpdateKeysResponse.setter(Builder::totalSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSizeInBytes").build()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(UpdateKeysResponse.getter(UpdateKeysResponse::eTag)).setter(UpdateKeysResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_COUNT_FIELD, TOTAL_SIZE_IN_BYTES_FIELD, E_TAG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateKeysResponse.memberNameToFieldInitializer();
    private final Integer itemCount;
    private final Long totalSizeInBytes;
    private final String eTag;

    private UpdateKeysResponse(BuilderImpl builder) {
        super(builder);
        this.itemCount = builder.itemCount;
        this.totalSizeInBytes = builder.totalSizeInBytes;
        this.eTag = builder.eTag;
    }

    public final Integer itemCount() {
        return this.itemCount;
    }

    public final Long totalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public final String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKeysResponse)) {
            return false;
        }
        UpdateKeysResponse other = (UpdateKeysResponse)((Object)obj);
        return Objects.equals(this.itemCount(), other.itemCount()) && Objects.equals(this.totalSizeInBytes(), other.totalSizeInBytes()) && Objects.equals(this.eTag(), other.eTag());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateKeysResponse").add("ItemCount", (Object)this.itemCount()).add("TotalSizeInBytes", (Object)this.totalSizeInBytes()).add("ETag", (Object)this.eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ItemCount": {
                return Optional.ofNullable(clazz.cast(this.itemCount()));
            }
            case "TotalSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.totalSizeInBytes()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ItemCount", ITEM_COUNT_FIELD);
        map.put("TotalSizeInBytes", TOTAL_SIZE_IN_BYTES_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateKeysResponse, T> g) {
        return obj -> g.apply((UpdateKeysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontKeyValueStoreResponse.BuilderImpl
    implements Builder {
        private Integer itemCount;
        private Long totalSizeInBytes;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKeysResponse model) {
            super(model);
            this.itemCount(model.itemCount);
            this.totalSizeInBytes(model.totalSizeInBytes);
            this.eTag(model.eTag);
        }

        public final Integer getItemCount() {
            return this.itemCount;
        }

        public final void setItemCount(Integer itemCount) {
            this.itemCount = itemCount;
        }

        @Override
        public final Builder itemCount(Integer itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final Long getTotalSizeInBytes() {
            return this.totalSizeInBytes;
        }

        public final void setTotalSizeInBytes(Long totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
        }

        @Override
        public final Builder totalSizeInBytes(Long totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public UpdateKeysResponse build() {
            return new UpdateKeysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontKeyValueStoreResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateKeysResponse> {
        public Builder itemCount(Integer var1);

        public Builder totalSizeInBytes(Long var1);

        public Builder eTag(String var1);
    }
}

