/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfrontkeyvaluestore.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.CloudFrontKeyValueStoreAsyncClient;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponseListItem;

public class ListKeysPublisher
implements SdkPublisher<ListKeysResponse> {
    private final CloudFrontKeyValueStoreAsyncClient client;
    private final ListKeysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListKeysPublisher(CloudFrontKeyValueStoreAsyncClient client, ListKeysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListKeysPublisher(CloudFrontKeyValueStoreAsyncClient client, ListKeysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListKeysResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListKeysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListKeysResponseListItem> items() {
        Function<ListKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListKeysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListKeysResponseFetcher
    implements AsyncPageFetcher<ListKeysResponse> {
        private ListKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListKeysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListKeysResponse> nextPage(ListKeysResponse previousPage) {
            if (previousPage == null) {
                return ListKeysPublisher.this.client.listKeys(ListKeysPublisher.this.firstRequest);
            }
            return ListKeysPublisher.this.client.listKeys((ListKeysRequest)((Object)ListKeysPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

