/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains a Lambda function association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaFunctionAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaFunctionAssociation.Builder, LambdaFunctionAssociation> {
    private static final SdkField<String> LAMBDA_FUNCTION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LambdaFunctionAssociation::lambdaFunctionARN))
            .setter(setter(Builder::lambdaFunctionARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctionARN")
                    .unmarshallLocationName("LambdaFunctionARN").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LambdaFunctionAssociation::eventTypeAsString))
            .setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType")
                    .unmarshallLocationName("EventType").build()).build();

    private static final SdkField<Boolean> INCLUDE_BODY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(LambdaFunctionAssociation::includeBody))
            .setter(setter(Builder::includeBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeBody")
                    .unmarshallLocationName("IncludeBody").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_FUNCTION_ARN_FIELD,
            EVENT_TYPE_FIELD, INCLUDE_BODY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String lambdaFunctionARN;

    private final String eventType;

    private final Boolean includeBody;

    private LambdaFunctionAssociation(BuilderImpl builder) {
        this.lambdaFunctionARN = builder.lambdaFunctionARN;
        this.eventType = builder.eventType;
        this.includeBody = builder.includeBody;
    }

    /**
     * <p>
     * The ARN of the Lambda function. You must specify the ARN of a function version; you can't specify a Lambda alias
     * or $LATEST.
     * </p>
     * 
     * @return The ARN of the Lambda function. You must specify the ARN of a function version; you can't specify a
     *         Lambda alias or $LATEST.
     */
    public String lambdaFunctionARN() {
        return lambdaFunctionARN;
    }

    /**
     * <p>
     * Specifies the event type that triggers a Lambda function invocation. You can specify the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>viewer-request</code>: The function executes when CloudFront receives a request from a viewer and before it
     * checks to see whether the requested object is in the edge cache.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>origin-request</code>: The function executes only when CloudFront forwards a request to your origin. When
     * the requested object is in the edge cache, the function doesn't execute.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>origin-response</code>: The function executes after CloudFront receives a response from the origin and
     * before it caches the object in the response. When the requested object is in the edge cache, the function doesn't
     * execute.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>viewer-response</code>: The function executes before CloudFront returns the requested object to the viewer.
     * The function executes regardless of whether the object was already in the edge cache.
     * </p>
     * <p>
     * If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return Specifies the event type that triggers a Lambda function invocation. You can specify the following
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>viewer-request</code>: The function executes when CloudFront receives a request from a viewer and
     *         before it checks to see whether the requested object is in the edge cache.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>origin-request</code>: The function executes only when CloudFront forwards a request to your
     *         origin. When the requested object is in the edge cache, the function doesn't execute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>origin-response</code>: The function executes after CloudFront receives a response from the origin
     *         and before it caches the object in the response. When the requested object is in the edge cache, the
     *         function doesn't execute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>viewer-response</code>: The function executes before CloudFront returns the requested object to the
     *         viewer. The function executes regardless of whether the object was already in the edge cache.
     *         </p>
     *         <p>
     *         If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
     *         </p>
     *         </li>
     * @see EventType
     */
    public EventType eventType() {
        return EventType.fromValue(eventType);
    }

    /**
     * <p>
     * Specifies the event type that triggers a Lambda function invocation. You can specify the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>viewer-request</code>: The function executes when CloudFront receives a request from a viewer and before it
     * checks to see whether the requested object is in the edge cache.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>origin-request</code>: The function executes only when CloudFront forwards a request to your origin. When
     * the requested object is in the edge cache, the function doesn't execute.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>origin-response</code>: The function executes after CloudFront receives a response from the origin and
     * before it caches the object in the response. When the requested object is in the edge cache, the function doesn't
     * execute.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>viewer-response</code>: The function executes before CloudFront returns the requested object to the viewer.
     * The function executes regardless of whether the object was already in the edge cache.
     * </p>
     * <p>
     * If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return Specifies the event type that triggers a Lambda function invocation. You can specify the following
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>viewer-request</code>: The function executes when CloudFront receives a request from a viewer and
     *         before it checks to see whether the requested object is in the edge cache.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>origin-request</code>: The function executes only when CloudFront forwards a request to your
     *         origin. When the requested object is in the edge cache, the function doesn't execute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>origin-response</code>: The function executes after CloudFront receives a response from the origin
     *         and before it caches the object in the response. When the requested object is in the edge cache, the
     *         function doesn't execute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>viewer-response</code>: The function executes before CloudFront returns the requested object to the
     *         viewer. The function executes regardless of whether the object was already in the edge cache.
     *         </p>
     *         <p>
     *         If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
     *         </p>
     *         </li>
     * @see EventType
     */
    public String eventTypeAsString() {
        return eventType;
    }

    /**
     * <p>
     * A flag that allows a Lambda function to have read access to the body content. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html"
     * >Accessing the Request Body by Choosing the Include Body Option</a> in the Amazon CloudFront Developer Guide.
     * </p>
     * 
     * @return A flag that allows a Lambda function to have read access to the body content. For more information, see
     *         <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html"
     *         >Accessing the Request Body by Choosing the Include Body Option</a> in the Amazon CloudFront Developer
     *         Guide.
     */
    public Boolean includeBody() {
        return includeBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionARN());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(includeBody());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionAssociation)) {
            return false;
        }
        LambdaFunctionAssociation other = (LambdaFunctionAssociation) obj;
        return Objects.equals(lambdaFunctionARN(), other.lambdaFunctionARN())
                && Objects.equals(eventTypeAsString(), other.eventTypeAsString())
                && Objects.equals(includeBody(), other.includeBody());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LambdaFunctionAssociation").add("LambdaFunctionARN", lambdaFunctionARN())
                .add("EventType", eventTypeAsString()).add("IncludeBody", includeBody()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LambdaFunctionARN":
            return Optional.ofNullable(clazz.cast(lambdaFunctionARN()));
        case "EventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "IncludeBody":
            return Optional.ofNullable(clazz.cast(includeBody()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunctionAssociation, T> g) {
        return obj -> g.apply((LambdaFunctionAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaFunctionAssociation> {
        /**
         * <p>
         * The ARN of the Lambda function. You must specify the ARN of a function version; you can't specify a Lambda
         * alias or $LATEST.
         * </p>
         * 
         * @param lambdaFunctionARN
         *        The ARN of the Lambda function. You must specify the ARN of a function version; you can't specify a
         *        Lambda alias or $LATEST.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionARN(String lambdaFunctionARN);

        /**
         * <p>
         * Specifies the event type that triggers a Lambda function invocation. You can specify the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>viewer-request</code>: The function executes when CloudFront receives a request from a viewer and
         * before it checks to see whether the requested object is in the edge cache.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>origin-request</code>: The function executes only when CloudFront forwards a request to your origin.
         * When the requested object is in the edge cache, the function doesn't execute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>origin-response</code>: The function executes after CloudFront receives a response from the origin and
         * before it caches the object in the response. When the requested object is in the edge cache, the function
         * doesn't execute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>viewer-response</code>: The function executes before CloudFront returns the requested object to the
         * viewer. The function executes regardless of whether the object was already in the edge cache.
         * </p>
         * <p>
         * If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
         * </p>
         * </li>
         * </ul>
         * 
         * @param eventType
         *        Specifies the event type that triggers a Lambda function invocation. You can specify the following
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>viewer-request</code>: The function executes when CloudFront receives a request from a viewer
         *        and before it checks to see whether the requested object is in the edge cache.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>origin-request</code>: The function executes only when CloudFront forwards a request to your
         *        origin. When the requested object is in the edge cache, the function doesn't execute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>origin-response</code>: The function executes after CloudFront receives a response from the
         *        origin and before it caches the object in the response. When the requested object is in the edge
         *        cache, the function doesn't execute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>viewer-response</code>: The function executes before CloudFront returns the requested object to
         *        the viewer. The function executes regardless of whether the object was already in the edge cache.
         *        </p>
         *        <p>
         *        If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
         *        </p>
         *        </li>
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * Specifies the event type that triggers a Lambda function invocation. You can specify the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>viewer-request</code>: The function executes when CloudFront receives a request from a viewer and
         * before it checks to see whether the requested object is in the edge cache.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>origin-request</code>: The function executes only when CloudFront forwards a request to your origin.
         * When the requested object is in the edge cache, the function doesn't execute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>origin-response</code>: The function executes after CloudFront receives a response from the origin and
         * before it caches the object in the response. When the requested object is in the edge cache, the function
         * doesn't execute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>viewer-response</code>: The function executes before CloudFront returns the requested object to the
         * viewer. The function executes regardless of whether the object was already in the edge cache.
         * </p>
         * <p>
         * If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
         * </p>
         * </li>
         * </ul>
         * 
         * @param eventType
         *        Specifies the event type that triggers a Lambda function invocation. You can specify the following
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>viewer-request</code>: The function executes when CloudFront receives a request from a viewer
         *        and before it checks to see whether the requested object is in the edge cache.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>origin-request</code>: The function executes only when CloudFront forwards a request to your
         *        origin. When the requested object is in the edge cache, the function doesn't execute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>origin-response</code>: The function executes after CloudFront receives a response from the
         *        origin and before it caches the object in the response. When the requested object is in the edge
         *        cache, the function doesn't execute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>viewer-response</code>: The function executes before CloudFront returns the requested object to
         *        the viewer. The function executes regardless of whether the object was already in the edge cache.
         *        </p>
         *        <p>
         *        If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
         *        </p>
         *        </li>
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(EventType eventType);

        /**
         * <p>
         * A flag that allows a Lambda function to have read access to the body content. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html">
         * Accessing the Request Body by Choosing the Include Body Option</a> in the Amazon CloudFront Developer Guide.
         * </p>
         * 
         * @param includeBody
         *        A flag that allows a Lambda function to have read access to the body content. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html"
         *        >Accessing the Request Body by Choosing the Include Body Option</a> in the Amazon CloudFront Developer
         *        Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeBody(Boolean includeBody);
    }

    static final class BuilderImpl implements Builder {
        private String lambdaFunctionARN;

        private String eventType;

        private Boolean includeBody;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionAssociation model) {
            lambdaFunctionARN(model.lambdaFunctionARN);
            eventType(model.eventType);
            includeBody(model.includeBody);
        }

        public final String getLambdaFunctionARN() {
            return lambdaFunctionARN;
        }

        @Override
        public final Builder lambdaFunctionARN(String lambdaFunctionARN) {
            this.lambdaFunctionARN = lambdaFunctionARN;
            return this;
        }

        public final void setLambdaFunctionARN(String lambdaFunctionARN) {
            this.lambdaFunctionARN = lambdaFunctionARN;
        }

        public final String getEventTypeAsString() {
            return eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType.toString());
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final Boolean getIncludeBody() {
            return includeBody;
        }

        @Override
        public final Builder includeBody(Boolean includeBody) {
            this.includeBody = includeBody;
            return this;
        }

        public final void setIncludeBody(Boolean includeBody) {
            this.includeBody = includeBody;
        }

        @Override
        public LambdaFunctionAssociation build() {
            return new LambdaFunctionAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
