/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.TrustStore;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTrustStoreResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, UpdateTrustStoreResponse> {
    private static final SdkField<TrustStore> TRUST_STORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrustStore").getter(UpdateTrustStoreResponse.getter(UpdateTrustStoreResponse::trustStore)).setter(UpdateTrustStoreResponse.setter(Builder::trustStore)).constructor(TrustStore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStore").unmarshallLocationName("TrustStore").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(UpdateTrustStoreResponse.getter(UpdateTrustStoreResponse::eTag)).setter(UpdateTrustStoreResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_STORE_FIELD, E_TAG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateTrustStoreResponse.memberNameToFieldInitializer();
    private final TrustStore trustStore;
    private final String eTag;

    private UpdateTrustStoreResponse(BuilderImpl builder) {
        super(builder);
        this.trustStore = builder.trustStore;
        this.eTag = builder.eTag;
    }

    public final TrustStore trustStore() {
        return this.trustStore;
    }

    public final String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trustStore());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrustStoreResponse)) {
            return false;
        }
        UpdateTrustStoreResponse other = (UpdateTrustStoreResponse)((Object)obj);
        return Objects.equals(this.trustStore(), other.trustStore()) && Objects.equals(this.eTag(), other.eTag());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTrustStoreResponse").add("TrustStore", (Object)this.trustStore()).add("ETag", (Object)this.eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrustStore": {
                return Optional.ofNullable(clazz.cast(this.trustStore()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrustStore", TRUST_STORE_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrustStoreResponse, T> g) {
        return obj -> g.apply((UpdateTrustStoreResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private TrustStore trustStore;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrustStoreResponse model) {
            super(model);
            this.trustStore(model.trustStore);
            this.eTag(model.eTag);
        }

        public final TrustStore.Builder getTrustStore() {
            return this.trustStore != null ? this.trustStore.toBuilder() : null;
        }

        public final void setTrustStore(TrustStore.BuilderImpl trustStore) {
            this.trustStore = trustStore != null ? trustStore.build() : null;
        }

        @Override
        public final Builder trustStore(TrustStore trustStore) {
            this.trustStore = trustStore;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public UpdateTrustStoreResponse build() {
            return new UpdateTrustStoreResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTrustStoreResponse> {
        public Builder trustStore(TrustStore var1);

        default public Builder trustStore(Consumer<TrustStore.Builder> trustStore) {
            return this.trustStore((TrustStore)((TrustStore.Builder)TrustStore.builder().applyMutation(trustStore)).build());
        }

        public Builder eTag(String var1);
    }
}

