/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.DistributionSummary;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByConnectionFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByConnectionFunctionResponse;

public class ListDistributionsByConnectionFunctionPublisher
implements SdkPublisher<ListDistributionsByConnectionFunctionResponse> {
    private final CloudFrontAsyncClient client;
    private final ListDistributionsByConnectionFunctionRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDistributionsByConnectionFunctionPublisher(CloudFrontAsyncClient client, ListDistributionsByConnectionFunctionRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDistributionsByConnectionFunctionPublisher(CloudFrontAsyncClient client, ListDistributionsByConnectionFunctionRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDistributionsByConnectionFunctionResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDistributionsByConnectionFunctionResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DistributionSummary> items() {
        return this.flatMapIterable(response -> response.distributionList().items());
    }

    private class ListDistributionsByConnectionFunctionResponseFetcher
    implements AsyncPageFetcher<ListDistributionsByConnectionFunctionResponse> {
        private ListDistributionsByConnectionFunctionResponseFetcher() {
        }

        public boolean hasNextPage(ListDistributionsByConnectionFunctionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.distributionList().nextMarker());
        }

        public CompletableFuture<ListDistributionsByConnectionFunctionResponse> nextPage(ListDistributionsByConnectionFunctionResponse previousPage) {
            if (previousPage == null) {
                return ListDistributionsByConnectionFunctionPublisher.this.client.listDistributionsByConnectionFunction(ListDistributionsByConnectionFunctionPublisher.this.firstRequest);
            }
            return ListDistributionsByConnectionFunctionPublisher.this.client.listDistributionsByConnectionFunction((ListDistributionsByConnectionFunctionRequest)((Object)ListDistributionsByConnectionFunctionPublisher.this.firstRequest.toBuilder().marker(previousPage.distributionList().nextMarker()).build()));
        }
    }
}

