/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.DistributionTenantSummary;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsResponse;

public class ListDistributionTenantsPublisher
implements SdkPublisher<ListDistributionTenantsResponse> {
    private final CloudFrontAsyncClient client;
    private final ListDistributionTenantsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDistributionTenantsPublisher(CloudFrontAsyncClient client, ListDistributionTenantsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDistributionTenantsPublisher(CloudFrontAsyncClient client, ListDistributionTenantsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDistributionTenantsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDistributionTenantsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DistributionTenantSummary> distributionTenantList() {
        return this.flatMapIterable(response -> response.distributionTenantList());
    }

    private class ListDistributionTenantsResponseFetcher
    implements AsyncPageFetcher<ListDistributionTenantsResponse> {
        private ListDistributionTenantsResponseFetcher() {
        }

        public boolean hasNextPage(ListDistributionTenantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListDistributionTenantsResponse> nextPage(ListDistributionTenantsResponse previousPage) {
            if (previousPage == null) {
                return ListDistributionTenantsPublisher.this.client.listDistributionTenants(ListDistributionTenantsPublisher.this.firstRequest);
            }
            return ListDistributionTenantsPublisher.this.client.listDistributionTenants((ListDistributionTenantsRequest)((Object)ListDistributionTenantsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

