/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.ConnectionFunctionSummary;
import software.amazon.awssdk.services.cloudfront.model.ListConnectionFunctionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListConnectionFunctionsResponse;

public class ListConnectionFunctionsPublisher
implements SdkPublisher<ListConnectionFunctionsResponse> {
    private final CloudFrontAsyncClient client;
    private final ListConnectionFunctionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConnectionFunctionsPublisher(CloudFrontAsyncClient client, ListConnectionFunctionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConnectionFunctionsPublisher(CloudFrontAsyncClient client, ListConnectionFunctionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConnectionFunctionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConnectionFunctionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConnectionFunctionSummary> connectionFunctions() {
        return this.flatMapIterable(response -> response.connectionFunctions());
    }

    private class ListConnectionFunctionsResponseFetcher
    implements AsyncPageFetcher<ListConnectionFunctionsResponse> {
        private ListConnectionFunctionsResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectionFunctionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListConnectionFunctionsResponse> nextPage(ListConnectionFunctionsResponse previousPage) {
            if (previousPage == null) {
                return ListConnectionFunctionsPublisher.this.client.listConnectionFunctions(ListConnectionFunctionsPublisher.this.firstRequest);
            }
            return ListConnectionFunctionsPublisher.this.client.listConnectionFunctions((ListConnectionFunctionsRequest)((Object)ListConnectionFunctionsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

