/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicy;
import software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OriginRequestPolicySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OriginRequestPolicySummary> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(OriginRequestPolicySummary.getter(OriginRequestPolicySummary::typeAsString)).setter(OriginRequestPolicySummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("Type").build()}).build();
    private static final SdkField<OriginRequestPolicy> ORIGIN_REQUEST_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OriginRequestPolicy").getter(OriginRequestPolicySummary.getter(OriginRequestPolicySummary::originRequestPolicy)).setter(OriginRequestPolicySummary.setter(Builder::originRequestPolicy)).constructor(OriginRequestPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginRequestPolicy").unmarshallLocationName("OriginRequestPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ORIGIN_REQUEST_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OriginRequestPolicySummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final OriginRequestPolicy originRequestPolicy;

    private OriginRequestPolicySummary(BuilderImpl builder) {
        this.type = builder.type;
        this.originRequestPolicy = builder.originRequestPolicy;
    }

    public final OriginRequestPolicyType type() {
        return OriginRequestPolicyType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final OriginRequestPolicy originRequestPolicy() {
        return this.originRequestPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.originRequestPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginRequestPolicySummary)) {
            return false;
        }
        OriginRequestPolicySummary other = (OriginRequestPolicySummary)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.originRequestPolicy(), other.originRequestPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"OriginRequestPolicySummary").add("Type", (Object)this.typeAsString()).add("OriginRequestPolicy", (Object)this.originRequestPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "OriginRequestPolicy": {
                return Optional.ofNullable(clazz.cast(this.originRequestPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("OriginRequestPolicy", ORIGIN_REQUEST_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OriginRequestPolicySummary, T> g) {
        return obj -> g.apply((OriginRequestPolicySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private OriginRequestPolicy originRequestPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginRequestPolicySummary model) {
            this.type(model.type);
            this.originRequestPolicy(model.originRequestPolicy);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OriginRequestPolicyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final OriginRequestPolicy.Builder getOriginRequestPolicy() {
            return this.originRequestPolicy != null ? this.originRequestPolicy.toBuilder() : null;
        }

        public final void setOriginRequestPolicy(OriginRequestPolicy.BuilderImpl originRequestPolicy) {
            this.originRequestPolicy = originRequestPolicy != null ? originRequestPolicy.build() : null;
        }

        @Override
        public final Builder originRequestPolicy(OriginRequestPolicy originRequestPolicy) {
            this.originRequestPolicy = originRequestPolicy;
            return this;
        }

        public OriginRequestPolicySummary build() {
            return new OriginRequestPolicySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OriginRequestPolicySummary> {
        public Builder type(String var1);

        public Builder type(OriginRequestPolicyType var1);

        public Builder originRequestPolicy(OriginRequestPolicy var1);

        default public Builder originRequestPolicy(Consumer<OriginRequestPolicy.Builder> originRequestPolicy) {
            return this.originRequestPolicy((OriginRequestPolicy)((OriginRequestPolicy.Builder)OriginRequestPolicy.builder().applyMutation(originRequestPolicy)).build());
        }
    }
}

