/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConnectionGroupByRoutingEndpointRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, GetConnectionGroupByRoutingEndpointRequest> {
    private static final SdkField<String> ROUTING_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingEndpoint").getter(GetConnectionGroupByRoutingEndpointRequest.getter(GetConnectionGroupByRoutingEndpointRequest::routingEndpoint)).setter(GetConnectionGroupByRoutingEndpointRequest.setter(Builder::routingEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("RoutingEndpoint").unmarshallLocationName("RoutingEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTING_ENDPOINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetConnectionGroupByRoutingEndpointRequest.memberNameToFieldInitializer();
    private final String routingEndpoint;

    private GetConnectionGroupByRoutingEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.routingEndpoint = builder.routingEndpoint;
    }

    public final String routingEndpoint() {
        return this.routingEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.routingEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionGroupByRoutingEndpointRequest)) {
            return false;
        }
        GetConnectionGroupByRoutingEndpointRequest other = (GetConnectionGroupByRoutingEndpointRequest)((Object)obj);
        return Objects.equals(this.routingEndpoint(), other.routingEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"GetConnectionGroupByRoutingEndpointRequest").add("RoutingEndpoint", (Object)this.routingEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoutingEndpoint": {
                return Optional.ofNullable(clazz.cast(this.routingEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("RoutingEndpoint", ROUTING_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConnectionGroupByRoutingEndpointRequest, T> g) {
        return obj -> g.apply((GetConnectionGroupByRoutingEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String routingEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionGroupByRoutingEndpointRequest model) {
            super(model);
            this.routingEndpoint(model.routingEndpoint);
        }

        public final String getRoutingEndpoint() {
            return this.routingEndpoint;
        }

        public final void setRoutingEndpoint(String routingEndpoint) {
            this.routingEndpoint = routingEndpoint;
        }

        @Override
        public final Builder routingEndpoint(String routingEndpoint) {
            this.routingEndpoint = routingEndpoint;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetConnectionGroupByRoutingEndpointRequest build() {
            return new GetConnectionGroupByRoutingEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConnectionGroupByRoutingEndpointRequest> {
        public Builder routingEndpoint(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

